/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store.delay;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.record.TenantInboxInstance;
import org.apache.bifromq.inbox.rpc.proto.SendLWTReply;
import org.apache.bifromq.inbox.rpc.proto.SendLWTRequest;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.apache.bifromq.inbox.store.delay.IDelayTaskRunner;
import org.apache.bifromq.inbox.store.delay.RetryableDelayedTask;

public class SendLWTTask
extends RetryableDelayedTask<SendLWTReply> {
    private final IInboxClient inboxClient;

    public SendLWTTask(Duration delay, long version, IInboxClient inboxClient) {
        this(delay, version, inboxClient, 0);
    }

    private SendLWTTask(Duration delay, long version, IInboxClient inboxClient, int retryCount) {
        super(delay, version, retryCount);
        this.inboxClient = inboxClient;
    }

    @Override
    protected CompletableFuture<SendLWTReply> callOperation(TenantInboxInstance key, IDelayTaskRunner<TenantInboxInstance> runner) {
        return this.inboxClient.sendLWT(SendLWTRequest.newBuilder().setReqId(System.nanoTime()).setTenantId(key.tenantId()).setInboxId(key.instance().inboxId()).setVersion(InboxVersion.newBuilder().setIncarnation(key.instance().incarnation()).setMod(this.mod).build()).setNow(HLC.INST.getPhysical()).build());
    }

    @Override
    protected boolean shouldRetry(SendLWTReply reply) {
        return reply.getCode() == SendLWTReply.Code.TRY_LATER || reply.getCode() == SendLWTReply.Code.BACK_PRESSURE_REJECTED;
    }

    @Override
    protected RetryableDelayedTask<SendLWTReply> createRetryTask(Duration newDelay) {
        return new SendLWTTask(newDelay, this.mod, this.inboxClient);
    }

    @Override
    protected String getTaskName() {
        return "Send LWT";
    }
}

