/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.inbox.store.balance;

import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import lombok.Generated;
import org.apache.bifromq.basekv.balance.StoreBalancer;
import org.apache.bifromq.basekv.balance.impl.ReplicaCntBalancer;
import org.apache.bifromq.inbox.store.spi.IInboxStoreBalancerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaCntBalancerFactory
implements IInboxStoreBalancerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReplicaCntBalancerFactory.class);
    private static final String VOTERS_PER_RANGE = "votersPerRange";
    private static final int DEFAULT_VOTERS_PER_RANGE = 3;
    private int votersPerRange;

    public void init(Struct config) {
        this.votersPerRange = (int)config.getFieldsOrDefault(VOTERS_PER_RANGE, Value.newBuilder().setNumberValue(3.0).build()).getNumberValue();
        if (this.votersPerRange < 1 || this.votersPerRange % 2 == 0) {
            this.votersPerRange = 3;
            log.warn("Invalid voters per range config {}, use default {}", (Object)this.votersPerRange, (Object)3);
        }
    }

    public StoreBalancer newBalancer(String clusterId, String localStoreId) {
        return new ReplicaCntBalancer(clusterId, localStoreId, this.votersPerRange, 0);
    }
}

