/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.metaservice;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeCRDT;
import org.apache.bifromq.basekv.metaservice.IBaseKVLandscapeReporter;
import org.apache.bifromq.basekv.metaservice.IBaseKVMetaService;
import org.apache.bifromq.basekv.proto.KVRangeStoreDescriptor;
import org.apache.bifromq.basekv.proto.StoreKey;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class BaseKVLandscapeReporter
implements IBaseKVLandscapeReporter {
    private final Logger log;
    private final String storeId;
    private final IBaseKVLandscapeCRDT landscapeCRDT;
    private final CompositeDisposable disposable = new CompositeDisposable();
    private volatile KVRangeStoreDescriptor latestDescriptor;

    BaseKVLandscapeReporter(String storeId, IBaseKVLandscapeCRDT landscapeCRDT) {
        this.log = MDCLogger.getLogger(BaseKVLandscapeReporter.class, (String[])new String[]{"clusterId", landscapeCRDT.clusterId(), "storeId", storeId});
        this.storeId = storeId;
        this.landscapeCRDT = landscapeCRDT;
        this.disposable.add(landscapeCRDT.landscape().observeOn(IBaseKVMetaService.SHARED_SCHEDULER).subscribe(this::afterInflation));
    }

    @Override
    public CompletableFuture<Void> report(KVRangeStoreDescriptor descriptor) {
        Optional<KVRangeStoreDescriptor> descriptorOnCRDT = this.landscapeCRDT.getStoreDescriptor(descriptor.getId());
        if (descriptorOnCRDT.isEmpty() || !descriptorOnCRDT.get().equals((Object)descriptor)) {
            this.latestDescriptor = descriptor;
            return this.landscapeCRDT.setStoreDescriptor(descriptor);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public Observable<Long> refreshSignal() {
        return this.landscapeCRDT.refreshSignal();
    }

    @Override
    public void stop() {
        this.landscapeCRDT.removeDescriptor(this.storeId).join();
        this.disposable.dispose();
    }

    private void afterInflation(Map<StoreKey, KVRangeStoreDescriptor> storedDescriptors) {
        KVRangeStoreDescriptor latestDescriptor;
        if (!storedDescriptors.containsKey(this.landscapeCRDT.toDescriptorKey(this.storeId)) && (latestDescriptor = this.latestDescriptor) != null) {
            this.log.debug("Rectify missing store descriptor");
            this.landscapeCRDT.setStoreDescriptor(latestDescriptor);
        }
    }
}

