/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.event.RaftEvent;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.RaftMessage;
import org.apache.bifromq.basekv.raft.proto.RaftNodeStatus;

public interface IRaftNode {
    public boolean isStarted();

    public String id();

    public RaftNodeStatus status();

    public void tick();

    public CompletableFuture<Long> propose(ByteString var1);

    public CompletableFuture<Long> readIndex();

    public void receive(String var1, RaftMessage var2);

    public CompletableFuture<Void> compact(ByteString var1, long var2);

    public CompletableFuture<Void> transferLeadership(String var1);

    public CompletableFuture<Void> recover();

    public ClusterConfig latestClusterConfig();

    public Boolean stepDown();

    public ByteString latestSnapshot();

    public CompletableFuture<Void> changeClusterConfig(String var1, Set<String> var2, Set<String> var3);

    public CompletableFuture<ILogEntryIterator> retrieveCommitted(long var1, long var3);

    public void start(IRaftMessageSender var1, IRaftEventListener var2, ISnapshotInstaller var3);

    public CompletableFuture<Void> stop();

    public static interface ISnapshotInstaller {
        public void install(ByteString var1, String var2, IAfterInstalledCallback var3);
    }

    public static interface IAfterInstalledCallback {
        public CompletableFuture<Void> call(ByteString var1, Throwable var2);
    }

    public static interface IRaftMessageSender {
        public void send(Map<String, List<RaftMessage>> var1);
    }

    public static interface IRaftEventListener {
        public void onEvent(RaftEvent var1);
    }
}

