/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Objects;
import java.util.Vector;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.util.ArgumentChecks;

final class ReshapedImage
extends PlanarImage {
    final RenderedImage source;
    private final int offsetX;
    private final int offsetY;
    private final int width;
    private final int height;
    private final int minX;
    private final int minY;
    private final int minTileX;
    private final int minTileY;

    ReshapedImage(RenderedImage source, long xmin, long ymin, long xmax, long ymax) {
        this.source = source;
        long lowerX = source.getMinX();
        long lowerY = source.getMinY();
        long upperX = (long)source.getWidth() + lowerX;
        long upperY = (long)source.getHeight() + lowerY;
        long tw = source.getTileWidth();
        long th = source.getTileHeight();
        long xo = source.getTileGridXOffset();
        long yo = source.getTileGridYOffset();
        long minTX = Math.floorDiv(Math.max(lowerX, xmin) - xo, tw);
        long minTY = Math.floorDiv(Math.max(lowerY, ymin) - yo, th);
        long maxTX = Math.floorDiv(Math.min(upperX, xmax) - xo, tw);
        long maxTY = Math.floorDiv(Math.min(upperY, ymax) - yo, th);
        long sx = Math.max(lowerX, minTX * tw + xo);
        long sy = Math.max(lowerY, minTY * th + yo);
        long x = Math.subtractExact(sx, xmin);
        long y = Math.subtractExact(sy, ymin);
        this.minX = Math.toIntExact(x);
        this.minY = Math.toIntExact(y);
        this.width = Math.toIntExact(Math.min(upperX, (maxTX + 1L) * tw + xo) - sx);
        this.height = Math.toIntExact(Math.min(upperY, (maxTY + 1L) * th + yo) - sy);
        this.offsetX = Math.toIntExact(x - sx);
        this.offsetY = Math.toIntExact(y - sy);
        this.minTileX = Math.toIntExact(minTX);
        this.minTileY = Math.toIntExact(minTY);
    }

    final boolean isIdentity() {
        return this.offsetX == 0 && this.offsetY == 0 && this.width >= this.source.getWidth() && this.height >= this.source.getHeight();
    }

    @Override
    public Vector<RenderedImage> getSources() {
        Vector<RenderedImage> sources = new Vector<RenderedImage>(1);
        sources.add(this.source);
        return sources;
    }

    @Override
    public Object getProperty(String name) {
        return this.source.getProperty(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.source.getPropertyNames();
    }

    @Override
    public ColorModel getColorModel() {
        return this.source.getColorModel();
    }

    @Override
    public SampleModel getSampleModel() {
        return this.source.getSampleModel();
    }

    @Override
    public int getTileWidth() {
        return this.source.getTileWidth();
    }

    @Override
    public int getTileHeight() {
        return this.source.getTileHeight();
    }

    @Override
    public int getMinX() {
        return this.minX;
    }

    @Override
    public int getMinY() {
        return this.minY;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getMinTileX() {
        return this.minTileX;
    }

    @Override
    public int getMinTileY() {
        return this.minTileY;
    }

    @Override
    public int getTileGridXOffset() {
        return Math.addExact(this.source.getTileGridXOffset(), this.offsetX);
    }

    @Override
    public int getTileGridYOffset() {
        return Math.addExact(this.source.getTileGridYOffset(), this.offsetY);
    }

    private Raster offset(Raster data) {
        return data.createTranslatedChild(Math.addExact(data.getMinX(), this.offsetX), Math.addExact(data.getMinY(), this.offsetY));
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        return this.offset(this.source.getTile(tileX, tileY));
    }

    @Override
    public Raster getData() {
        if (this.width >= this.source.getWidth() && this.height >= this.source.getHeight()) {
            return this.offset(this.source.getData());
        }
        return this.copyData(new Rectangle(this.minX, this.minY, this.width, this.height));
    }

    @Override
    public Raster getData(Rectangle aoi) {
        ArgumentChecks.ensureNonNull((String)"aoi", (Object)aoi);
        return this.copyData(new Rectangle(aoi));
    }

    private Raster copyData(Rectangle aoi) {
        aoi.x = Math.subtractExact(aoi.x, this.offsetX);
        aoi.y = Math.subtractExact(aoi.y, this.offsetY);
        Raster data = this.source.getData(aoi);
        return data.createTranslatedChild(Math.addExact(data.getMinX(), this.offsetX), Math.addExact(data.getMinY(), this.offsetY));
    }

    @Override
    public WritableRaster copyData(WritableRaster raster) {
        WritableRaster data = raster != null ? raster.createWritableTranslatedChild(Math.subtractExact(raster.getMinX(), this.offsetX), Math.subtractExact(raster.getMinY(), this.offsetY)) : null;
        if ((data = this.source.copyData(data)).getWritableParent() == raster) {
            return raster;
        }
        return data.createWritableTranslatedChild(Math.addExact(data.getMinX(), this.offsetX), Math.addExact(data.getMinY(), this.offsetY));
    }

    @Override
    public String verify() {
        String inconsistency;
        if (this.source instanceof PlanarImage && (inconsistency = ((PlanarImage)this.source).verify()) != null) {
            return "source." + inconsistency;
        }
        if (this.getMinX() != this.source.getMinX() + (this.minTileX - this.source.getMinTileX()) * this.getTileWidth() + this.offsetX) {
            return "minX";
        }
        if (this.getMinY() != this.source.getMinY() + (this.minTileY - this.source.getMinTileY()) * this.getTileHeight() + this.offsetY) {
            return "minY";
        }
        if (this.getTileGridXOffset() != super.getTileGridXOffset()) {
            return "tileGridXOffset";
        }
        if (this.getTileGridYOffset() != super.getTileGridYOffset()) {
            return "tileGridYOffset";
        }
        return super.verify();
    }

    public int hashCode() {
        return Objects.hash(this.source, this.minX, this.minY, this.width, this.height);
    }

    public boolean equals(Object object) {
        if (object instanceof ReshapedImage) {
            ReshapedImage other = (ReshapedImage)object;
            return this.source.equals(other.source) && this.minX == other.minX && this.minY == other.minY && this.width == other.width && this.height == other.height && this.offsetX == other.offsetX && this.offsetY == other.offsetY && this.minTileX == other.minTileX && this.minTileY == other.minTileY;
        }
        return false;
    }
}

