/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.model;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Info;
import org.locationtech.jts.geom.Geometry;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Element
implements Entity {
    protected Long id;
    protected Info info;
    protected Map<String, Object> tags;
    protected Geometry geometry;

    protected Element() {
    }

    protected Element(long id, Info info, Map<String, Object> tags) {
        this(id, info, tags, null);
    }

    protected Element(long id, Info info, Map<String, Object> tags, Geometry geometry) {
        this.id = id;
        this.info = info;
        this.tags = tags;
        this.geometry = geometry;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, Object> tags) {
        this.tags = tags;
    }

    public Geometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.geometry = geometry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Element)) {
            return false;
        }
        Element element = (Element)o;
        return this.id == element.id && Objects.equals(this.info, element.info) && Objects.equals(this.tags, element.tags) && Objects.equals(this.geometry, element.geometry);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.info, this.tags, this.geometry);
    }

    public String toString() {
        return new StringJoiner(", ", Element.class.getSimpleName() + "[", "]").add("id=" + this.id).add("info=" + this.info).add("tags=" + this.tags).add("geometry=" + this.geometry).toString();
    }
}

