/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.server;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileResource {
    private static final Logger logger = LoggerFactory.getLogger(TileResource.class);
    public static final String TILE_ENCODING = "gzip";
    public static final String TILE_TYPE = "application/vnd.mapbox-vector-tile";
    private final Supplier<TileStore> tileStoreSupplier;

    public TileResource(Supplier<TileStore> tileStoreSupplier) {
        this.tileStoreSupplier = tileStoreSupplier;
    }

    @Get(value="regex:^/tiles/(?<z>[0-9]+)/(?<x>[0-9]+)/(?<y>[0-9]+).mvt$")
    @Blocking
    public HttpResponse tile(@Param(value="z") int z, @Param(value="x") int x, @Param(value="y") int y) {
        TileCoord tileCoord = new TileCoord(x, y, z);
        try {
            TileStore tileStore = this.tileStoreSupplier.get();
            ByteBuffer blob = tileStore.read(tileCoord);
            if (blob != null) {
                ResponseHeaders headers = ResponseHeaders.builder((int)200).add((CharSequence)"Content-Type", TILE_TYPE).add((CharSequence)"Content-Encoding", TILE_ENCODING).add((CharSequence)"Access-Control-Allow-Origin", "*").build();
                byte[] bytes = new byte[blob.remaining()];
                blob.get(bytes);
                HttpData data = HttpData.wrap((byte[])bytes);
                return HttpResponse.of((ResponseHeaders)headers, (HttpData)data);
            }
            return HttpResponse.of((int)204);
        }
        catch (TileStoreException ex) {
            logger.error("Error while reading tile.", (Throwable)ex);
            return HttpResponse.of((int)404);
        }
    }
}

