/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.dao;

import com.j256.ormlite.dao.ObjectCache;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LruObjectCache
implements ObjectCache {
    private final int capacity;
    private final ConcurrentHashMap<Class<?>, Map<Object, Object>> classMaps = new ConcurrentHashMap();

    public LruObjectCache(int capacity) {
        this.capacity = capacity;
    }

    @Override
    public synchronized <T> void registerClass(Class<T> clazz) {
        Map<Object, Object> objectMap = this.classMaps.get(clazz);
        if (objectMap == null) {
            objectMap = Collections.synchronizedMap(new LimitedLinkedHashMap(this.capacity));
            this.classMaps.put(clazz, objectMap);
        }
    }

    @Override
    public <T, ID> T get(Class<T> clazz, ID id) {
        Object obj;
        Map<Object, Object> objectMap = this.getMapForClass(clazz);
        if (objectMap == null) {
            return null;
        }
        Object castObj = obj = objectMap.get(id);
        return (T)castObj;
    }

    @Override
    public <T, ID> void put(Class<T> clazz, ID id, T data) {
        Map<Object, Object> objectMap = this.getMapForClass(clazz);
        if (objectMap != null) {
            objectMap.put(id, data);
        }
    }

    @Override
    public <T> void clear(Class<T> clazz) {
        Map<Object, Object> objectMap = this.getMapForClass(clazz);
        if (objectMap != null) {
            objectMap.clear();
        }
    }

    @Override
    public void clearAll() {
        for (Map<Object, Object> objectMap : this.classMaps.values()) {
            objectMap.clear();
        }
    }

    @Override
    public <T, ID> void remove(Class<T> clazz, ID id) {
        Map<Object, Object> objectMap = this.getMapForClass(clazz);
        if (objectMap != null) {
            objectMap.remove(id);
        }
    }

    @Override
    public <T, ID> T updateId(Class<T> clazz, ID oldId, ID newId) {
        Map<Object, Object> objectMap = this.getMapForClass(clazz);
        if (objectMap == null) {
            return null;
        }
        Object obj = objectMap.remove(oldId);
        if (obj == null) {
            return null;
        }
        objectMap.put(newId, obj);
        Object castObj = obj;
        return (T)castObj;
    }

    @Override
    public <T> int size(Class<T> clazz) {
        Map<Object, Object> objectMap = this.getMapForClass(clazz);
        if (objectMap == null) {
            return 0;
        }
        return objectMap.size();
    }

    @Override
    public int sizeAll() {
        int size = 0;
        for (Map<Object, Object> objectMap : this.classMaps.values()) {
            size += objectMap.size();
        }
        return size;
    }

    private Map<Object, Object> getMapForClass(Class<?> clazz) {
        Map<Object, Object> objectMap = this.classMaps.get(clazz);
        if (objectMap == null) {
            return null;
        }
        return objectMap;
    }

    private static class LimitedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = -4566528080395573236L;
        private final int capacity;

        public LimitedLinkedHashMap(int capacity) {
            super(capacity, 0.75f, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.capacity;
        }
    }
}

