/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.baremaps.stream.HoldingConsumer;

public class PartitionedSpliterator<T>
implements Spliterator<List<T>> {
    private final Spliterator<T> spliterator;
    private final int partitionSize;

    public PartitionedSpliterator(Spliterator<T> spliterator, int partitionSize) {
        this.spliterator = spliterator;
        this.partitionSize = partitionSize;
    }

    @Override
    public boolean tryAdvance(Consumer<? super List<T>> action) {
        int size;
        ArrayList list = new ArrayList(this.partitionSize);
        for (size = 0; size < this.partitionSize; ++size) {
            if (!this.spliterator.tryAdvance(list::add)) break;
        }
        if (size == 0) {
            return false;
        }
        action.accept(list);
        return true;
    }

    @Override
    public Spliterator<List<T>> trySplit() {
        HoldingConsumer consumer = new HoldingConsumer();
        this.tryAdvance(consumer);
        return Stream.ofNullable((List)consumer.value()).spliterator();
    }

    @Override
    public long estimateSize() {
        return this.spliterator.estimateSize() / (long)this.partitionSize;
    }

    @Override
    public int characteristics() {
        return this.spliterator.characteristics();
    }
}

