/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.repository;

import java.util.List;
import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.model.Change;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.repository.Repository;
import org.apache.baremaps.openstreetmap.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutChangeImporter
implements Consumer<Change> {
    private static final Logger logger = LoggerFactory.getLogger(PutChangeImporter.class);
    private final Repository<Long, Node> nodeRepository;
    private final Repository<Long, Way> wayRepository;
    private final Repository<Long, Relation> relationRepository;

    public PutChangeImporter(Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository) {
        this.nodeRepository = nodeRepository;
        this.wayRepository = wayRepository;
        this.relationRepository = relationRepository;
    }

    @Override
    public void accept(Change change) {
        List<Node> nodes = change.getEntities().stream().filter(entity -> entity instanceof Node).map(entity -> (Node)entity).toList();
        List<Long> nodeIds = nodes.stream().map(Element::getId).toList();
        List<Way> ways = change.getEntities().stream().filter(entity -> entity instanceof Way).map(entity -> (Way)entity).toList();
        List<Long> wayIds = ways.stream().map(Element::getId).toList();
        List<Relation> relations = change.getEntities().stream().filter(entity -> entity instanceof Relation).map(entity -> (Relation)entity).toList();
        List<Long> relationIds = relations.stream().map(Element::getId).toList();
        try {
            switch (change.getType()) {
                case CREATE: 
                case MODIFY: {
                    if (!nodes.isEmpty()) {
                        logger.trace("Creating {} nodes", (Object)nodes.size());
                        this.nodeRepository.put(nodes);
                    }
                    if (!ways.isEmpty()) {
                        logger.trace("Creating {} ways", (Object)ways.size());
                        this.wayRepository.put(ways);
                    }
                    if (relations.isEmpty()) break;
                    logger.trace("Creating {} relations", (Object)relations.size());
                    this.relationRepository.put(relations);
                    break;
                }
                case DELETE: {
                    if (!nodes.isEmpty()) {
                        logger.trace("Deleting {} nodes", (Object)nodes.size());
                        this.nodeRepository.delete(nodeIds);
                    }
                    if (!ways.isEmpty()) {
                        logger.trace("Deleting {} ways", (Object)ways.size());
                        this.wayRepository.delete(wayIds);
                    }
                    if (relations.isEmpty()) break;
                    logger.trace("Deleting {} relations", (Object)relations.size());
                    this.relationRepository.delete(relationIds);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error while saving changes", (Throwable)e);
        }
    }
}

