/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.algorithm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.baremaps.database.collection.DataList;

public class ExternalMergeSort {
    public static <T> void sort(DataList<T> input, DataList<T> output, Comparator<T> comparator, Supplier<DataList<T>> tempLists, long batchSize, boolean distinct, boolean parallel) throws IOException {
        ExternalMergeSort.mergeSortedBatches(ExternalMergeSort.sortInBatch(input, comparator, tempLists, batchSize, distinct, parallel), output, comparator, distinct);
    }

    private static <T> long mergeSortedBatches(List<DataList<T>> batches, DataList<T> output, Comparator<T> comparator, boolean distinct) throws IOException {
        DataStack<T> stack;
        PriorityQueue<DataStack> queue = new PriorityQueue<DataStack>(batches.size(), (i, j) -> comparator.compare(i.peek(), j.peek()));
        for (DataList<T> input : batches) {
            if (input.sizeAsLong() == 0L || (stack = new DataStack<T>(input)).empty()) continue;
            queue.add(stack);
        }
        long counter = 0L;
        if (!distinct) {
            while (queue.size() > 0) {
                stack = (DataStack<T>)queue.poll();
                Object value = stack.pop();
                output.addIndexed(value);
                ++counter;
                if (stack.empty()) {
                    stack.close();
                    continue;
                }
                queue.add(stack);
            }
        } else {
            DataStack stack2;
            Object last = null;
            if (queue.size() > 0) {
                stack2 = (DataStack)queue.poll();
                last = stack2.pop();
                output.addIndexed(last);
                ++counter;
                if (stack2.empty()) {
                    stack2.close();
                } else {
                    queue.add(stack2);
                }
            }
            while (queue.size() > 0) {
                stack2 = (DataStack)queue.poll();
                Object value = stack2.pop();
                if (comparator.compare(value, last) != 0) {
                    output.addIndexed(value);
                    last = value;
                }
                ++counter;
                if (stack2.empty()) {
                    stack2.close();
                    continue;
                }
                queue.add(stack2);
            }
        }
        for (DataList<T> batch : batches) {
            batch.clear();
        }
        return counter;
    }

    public static <T> List<DataList<T>> sortInBatch(DataList<T> input, Comparator<T> comparator, Supplier<DataList<T>> supplier, long batchSize, boolean distinct, boolean parallel) {
        ArrayList<DataList<T>> batches = new ArrayList<DataList<T>>();
        ArrayList<T> batch = new ArrayList<T>();
        Iterator<T> iterator = input.iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            batch.add(element);
            if ((long)batch.size() < batchSize && iterator.hasNext()) continue;
            DataList sortedBatch = ExternalMergeSort.sortBatch(batch, comparator, supplier, distinct, parallel);
            batches.add(sortedBatch);
            batch.clear();
        }
        return batches;
    }

    public static <T> DataList<T> sortBatch(List<T> batch, Comparator<T> comparator, Supplier<DataList<T>> supplier, boolean distinct, boolean parallel) {
        DataList<T> output = supplier.get();
        Stream<Object> tmpStream = batch.stream().sorted(comparator);
        if (parallel) {
            tmpStream = (Stream<Object>)tmpStream.parallel();
        }
        if (distinct) {
            tmpStream = tmpStream.distinct();
        }
        tmpStream.forEachOrdered(output::addIndexed);
        return output;
    }

    static final class DataStack<T>
    implements AutoCloseable {
        private DataList<T> list;
        private Long index = 0L;
        private T cache;

        public DataStack(DataList<T> list) {
            this.list = list;
            this.reload();
        }

        public boolean empty() {
            return this.index > this.list.sizeAsLong();
        }

        public T peek() {
            return this.cache;
        }

        public T pop() {
            T answer = this.peek();
            this.reload();
            return answer;
        }

        private void reload() {
            this.cache = this.list.get(this.index);
            Long l = this.index;
            this.index = this.index + 1L;
        }

        @Override
        public void close() {
            this.list.clear();
        }
    }
}

