/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToLengthNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;

public abstract class JSToLengthNode
extends JavaScriptBaseNode {
    @NeverDefault
    public static JSToLengthNode create() {
        return JSToLengthNodeGen.create();
    }

    public abstract long executeLong(Object var1);

    @Specialization
    protected final long doInt(int value, @Cached @Cached.Shared(value="negativeBranch") InlinedBranchProfile negativeBranch) {
        if (value < 0) {
            negativeBranch.enter((Node)this);
            return 0L;
        }
        return value;
    }

    @Specialization
    protected final long doSafeInteger(SafeInteger value, @Cached @Cached.Shared(value="negativeBranch") InlinedBranchProfile negativeBranch) {
        long longValue = value.longValue();
        if (longValue < 0L) {
            negativeBranch.enter((Node)this);
            return 0L;
        }
        return longValue;
    }

    @Specialization
    protected final long doDouble(double value, @Cached @Cached.Shared(value="negativeBranch") InlinedBranchProfile negativeBranch, @Cached @Cached.Shared(value="tooLargeBranch") InlinedBranchProfile tooLargeBranch) {
        return this.doLong((long)value, negativeBranch, tooLargeBranch);
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static long doUndefined(Object value) {
        return 0L;
    }

    @Specialization
    protected final long doObject(Object value, @Cached JSToNumberNode toNumberNode, @Cached @Cached.Shared(value="negativeBranch") InlinedBranchProfile negativeBranch, @Cached @Cached.Shared(value="tooLargeBranch") InlinedBranchProfile tooLargeBranch) {
        Number result = (Number)toNumberNode.execute(value);
        return this.doLong(JSRuntime.toInteger(result), negativeBranch, tooLargeBranch);
    }

    private long doLong(long value, InlinedBranchProfile negativeBranch, InlinedBranchProfile tooLargeBranch) {
        if (value < 0L) {
            negativeBranch.enter((Node)this);
            return 0L;
        }
        if (value > JSRuntime.MAX_SAFE_INTEGER_LONG) {
            tooLargeBranch.enter((Node)this);
            return JSRuntime.MAX_SAFE_INTEGER_LONG;
        }
        return value;
    }
}

