/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.util.ObjectCollectingUtil;
import com.linecorp.armeria.internal.server.annotation.ClassUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

final class AggregatedResponseConverterFunction
implements ResponseConverterFunction {
    private final ResponseConverterFunction responseConverter;

    AggregatedResponseConverterFunction(ResponseConverterFunction responseConverter) {
        this.responseConverter = responseConverter;
    }

    @Override
    public Boolean isResponseStreaming(Type returnType, @Nullable MediaType contentType) {
        Class<?> clazz = ClassUtil.typeToClass(ClassUtil.unwrapUnaryAsyncType(returnType));
        if (clazz == null) {
            return null;
        }
        if (HttpResponse.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Publisher.class.isAssignableFrom(clazz) || Stream.class.isAssignableFrom(clazz)) {
            return false;
        }
        return null;
    }

    @Override
    public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
        CompletableFuture<Object> f;
        if (result instanceof Publisher) {
            f = ObjectCollectingUtil.collectFrom((Publisher)result, ctx);
        } else if (result instanceof Stream) {
            f = ObjectCollectingUtil.collectFrom((Stream)result, ctx.blockingTaskExecutor());
        } else {
            return (HttpResponse)ResponseConverterFunction.fallthrough();
        }
        return HttpResponse.of((CompletableFuture<? extends HttpResponse>)f.thenApply(aggregated -> {
            try {
                return this.responseConverter.convertResponse(ctx, headers, aggregated, trailers);
            }
            catch (Exception ex) {
                return (HttpResponse)Exceptions.throwUnsafely(ex);
            }
        }));
    }
}

