/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipFile;

public final class AppRootFinder {
    public static Path findCurrent() {
        return AppRootFinder.findCurrent(1);
    }

    public static Path findCurrent(int callDepth) {
        final AtomicReference classContextRef = new AtomicReference();
        new SecurityManager(){
            {
                classContextRef.set(this.getClassContext());
            }
        };
        Class[] classes = (Class[])classContextRef.get();
        int toSkip = 2;
        if (callDepth < 0 || callDepth + 2 >= classes.length) {
            throw new IndexOutOfBoundsException("callDepth out of range: " + callDepth + " (expected: 0 <= callDepth < " + (classes.length - 2) + ')');
        }
        return AppRootFinder.find(classes[2 + callDepth]);
    }

    public static Path find(Class<?> clazz) {
        File f;
        Objects.requireNonNull(clazz, "clazz");
        ProtectionDomain pd = clazz.getProtectionDomain();
        if (pd == null) {
            throw new IllegalArgumentException(clazz + " does not have a protection domain.");
        }
        CodeSource cs = pd.getCodeSource();
        if (cs == null) {
            throw new IllegalArgumentException(clazz + " does not have a code source.");
        }
        URL url = cs.getLocation();
        if (url == null) {
            throw new IllegalArgumentException(clazz + " does not have a location.");
        }
        if (!"file".equalsIgnoreCase(url.getProtocol())) {
            throw new IllegalArgumentException(clazz + " is not on a file system: " + url);
        }
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException ignored) {
            f = new File(url.getPath());
        }
        Path path = f.toPath();
        if (!Files.isDirectory(path, new LinkOption[0]) && !AppRootFinder.isZip(path)) {
            throw new IllegalArgumentException(f + " is not a JAR, WAR or directory.");
        }
        return path;
    }

    private static boolean isZip(Path path) {
        boolean bl;
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        ZipFile ignored = new ZipFile(path.toFile());
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored2) {
                return false;
            }
        }
        ignored.close();
        return bl;
    }

    private AppRootFinder() {
    }
}

