/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.metric;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class MoreMeters {
    private static final double[] PERCENTILES = new double[]{0.0, 0.5, 0.75, 0.9, 0.95, 0.98, 0.99, 0.999, 1.0};
    private static final boolean MICROMETER_1_5 = Stream.of(DistributionSummary.Builder.class.getMethods()).anyMatch(method -> method != null && "serviceLevelObjectives".equals(method.getName()));
    private static volatile DistributionStatisticConfig distStatCfg = DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).sla(new long[0]).percentiles(PERCENTILES).percentilePrecision(Integer.valueOf(2)).minimumExpectedValue(Long.valueOf(1L)).maximumExpectedValue(Long.valueOf(Long.MAX_VALUE)).expiry(Duration.ofMinutes(3L)).bufferLength(Integer.valueOf(3)).build();

    public static void setDistributionStatisticConfig(DistributionStatisticConfig config) {
        Objects.requireNonNull(config, "config");
        distStatCfg = config;
    }

    public static DistributionStatisticConfig distributionStatisticConfig() {
        return distStatCfg;
    }

    public static DistributionSummary newDistributionSummary(MeterRegistry registry, String name, Iterable<Tag> tags) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(tags, "tags");
        DistributionSummary.Builder builder = DistributionSummary.builder((String)name).tags(tags).publishPercentiles(distStatCfg.getPercentiles()).publishPercentileHistogram(distStatCfg.isPercentileHistogram()).percentilePrecision(distStatCfg.getPercentilePrecision()).distributionStatisticBufferLength(distStatCfg.getBufferLength()).distributionStatisticExpiry(distStatCfg.getExpiry());
        if (MICROMETER_1_5) {
            builder.maximumExpectedValue(distStatCfg.getMaximumExpectedValueAsDouble()).minimumExpectedValue(distStatCfg.getMinimumExpectedValueAsDouble()).serviceLevelObjectives(distStatCfg.getServiceLevelObjectiveBoundaries());
        } else {
            Double maxExpectedValueNanos = distStatCfg.getMaximumExpectedValueAsDouble();
            Double minExpectedValueNanos = distStatCfg.getMinimumExpectedValueAsDouble();
            Long maxExpectedValue = maxExpectedValueNanos != null ? Long.valueOf(maxExpectedValueNanos.longValue()) : null;
            Long minExpectedValue = minExpectedValueNanos != null ? Long.valueOf(minExpectedValueNanos.longValue()) : null;
            builder.maximumExpectedValue(maxExpectedValue);
            builder.minimumExpectedValue(minExpectedValue);
            double[] slas = distStatCfg.getServiceLevelObjectiveBoundaries();
            if (slas != null) {
                builder.sla(Arrays.stream(slas).mapToLong(sla -> (long)sla).toArray());
            }
        }
        return builder.register(registry);
    }

    public static Timer newTimer(MeterRegistry registry, String name, Iterable<Tag> tags) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(tags, "tags");
        Double maxExpectedValueNanos = distStatCfg.getMaximumExpectedValueAsDouble();
        Double minExpectedValueNanos = distStatCfg.getMinimumExpectedValueAsDouble();
        Duration maxExpectedValue = maxExpectedValueNanos != null ? Duration.ofNanos(maxExpectedValueNanos.longValue()) : null;
        Duration minExpectedValue = minExpectedValueNanos != null ? Duration.ofNanos(minExpectedValueNanos.longValue()) : null;
        return Timer.builder((String)name).tags(tags).maximumExpectedValue(maxExpectedValue).minimumExpectedValue(minExpectedValue).publishPercentiles(distStatCfg.getPercentiles()).publishPercentileHistogram(distStatCfg.isPercentileHistogram()).percentilePrecision(distStatCfg.getPercentilePrecision()).distributionStatisticBufferLength(distStatCfg.getBufferLength()).distributionStatisticExpiry(distStatCfg.getExpiry()).register(registry);
    }

    public static Map<String, Double> measureAll(MeterRegistry registry) {
        Objects.requireNonNull(registry, "registry");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        registry.forEachMeter(meter -> Streams.stream(meter.measure()).forEach(measurement -> {
            String fullName = MoreMeters.measurementName(meter.getId(), measurement);
            double value = measurement.getValue();
            builder.put(fullName, value);
        }));
        return builder.build();
    }

    private static String measurementName(Meter.Id id, Measurement measurement) {
        StringBuilder buf = new StringBuilder();
        buf.append(id.getName());
        buf.append('#');
        buf.append(measurement.getStatistic().getTagValueRepresentation());
        Iterator<Tag> tagsIterator = id.getTags().iterator();
        if (tagsIterator.hasNext()) {
            buf.append('{');
            tagsIterator.forEachRemaining(tag -> buf.append(tag.getKey()).append('=').append(tag.getValue()).append(','));
            buf.setCharAt(buf.length() - 1, '}');
        }
        return buf.toString();
    }

    private MoreMeters() {
    }
}

