package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.baremaps.ogcapi.model.ExtentSpatial;
import org.apache.baremaps.ogcapi.model.ExtentTemporal;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The extent of the data in the collection. In the Core only spatial and temporal extents are specified. Extensions may add additional members to represent other extents, for example, thermal or pressure ranges.  The first item in the array describes the overall extent of the data. All subsequent items describe more precise extents, e.g., to identify clusters of data. Clients only interested in the overall extent will only need to access the first item in each array.
 **/
@ApiModel(description = "The extent of the data in the collection. In the Core only spatial and temporal extents are specified. Extensions may add additional members to represent other extents, for example, thermal or pressure ranges.  The first item in the array describes the overall extent of the data. All subsequent items describe more precise extents, e.g., to identify clusters of data. Clients only interested in the overall extent will only need to access the first item in each array.")
@JsonTypeName("extent")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class Extent   {
  private @Valid ExtentSpatial spatial;
  private @Valid ExtentTemporal temporal;

  /**
   **/
  public Extent spatial(ExtentSpatial spatial) {
    this.spatial = spatial;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("spatial")
  public ExtentSpatial getSpatial() {
    return spatial;
  }

  @JsonProperty("spatial")
  public void setSpatial(ExtentSpatial spatial) {
    this.spatial = spatial;
  }

  /**
   **/
  public Extent temporal(ExtentTemporal temporal) {
    this.temporal = temporal;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("temporal")
  public ExtentTemporal getTemporal() {
    return temporal;
  }

  @JsonProperty("temporal")
  public void setTemporal(ExtentTemporal temporal) {
    this.temporal = temporal;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Extent extent = (Extent) o;
    return Objects.equals(this.spatial, extent.spatial) &&
        Objects.equals(this.temporal, extent.temporal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(spatial, temporal);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Extent {\n");
    
    sb.append("    spatial: ").append(toIndentedString(spatial)).append("\n");
    sb.append("    temporal: ").append(toIndentedString(temporal)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

