/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.ogcapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import io.servicetalk.data.jackson.jersey.ServiceTalkJacksonSerializerFeature;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import javax.ws.rs.core.Application;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.ogcapi.ApiResource;
import org.apache.baremaps.ogcapi.CollectionsResource;
import org.apache.baremaps.ogcapi.ConformanceResource;
import org.apache.baremaps.ogcapi.DefaultResource;
import org.apache.baremaps.ogcapi.StylesResource;
import org.apache.baremaps.ogcapi.TilesResource;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.tilestore.TileCache;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.postgres.PostgresTileStore;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.apache.baremaps.utils.PostgresUtils;
import org.apache.baremaps.vectortile.tileset.Tileset;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ogcapi", description={"OGC API server (experimental)."})
public class OgcApi
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(OgcApi.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--database"}, paramLabel="DATABASE", description={"The JDBC url of Postgres."}, required=true)
    private String database;
    @CommandLine.Option(names={"--cache"}, paramLabel="CACHE", description={"The caffeine cache directive."})
    private String cache = "";
    @CommandLine.Option(names={"--tileset"}, paramLabel="TILESET", description={"The tileset file."}, required=true)
    private Path tileset;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path style;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        final ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        ConfigReader configReader = new ConfigReader();
        Tileset config = (Tileset)objectMapper.readValue(configReader.read(this.tileset), Tileset.class);
        CaffeineSpec caffeineSpec = CaffeineSpec.parse((String)this.cache);
        final DataSource dataSource = PostgresUtils.createDataSource((String)this.database);
        PostgresTileStore tileStore = new PostgresTileStore(dataSource, config);
        final TileCache tileCache = new TileCache((TileStore)tileStore, caffeineSpec);
        ResourceConfig application = new ResourceConfig().registerClasses(new Class[]{CorsFilter.class, MultiPartFeature.class, DefaultResource.class, ApiResource.class, ConformanceResource.class, CollectionsResource.class, StylesResource.class, TilesResource.class}).register((Object)ServiceTalkJacksonSerializerFeature.newContextResolver((ObjectMapper)objectMapper)).register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(OgcApi.this.tileset).to(Path.class).named("tileset");
                this.bind(OgcApi.this.style).to(Path.class).named("style");
                this.bind(dataSource).to(DataSource.class);
                this.bind(tileCache).to(TileStore.class);
                this.bind(objectMapper).to(ObjectMapper.class);
            }
        });
        BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
        HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
        logger.info("Listening on {}", (Object)serverContext.listenAddress());
        serverContext.awaitShutdown();
        return 0;
    }
}

