/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.servicetalk.data.jackson.jersey.ServiceTalkJacksonSerializerFeature;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.ws.rs.core.Application;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.config.ConfigReader;
import org.apache.baremaps.server.ChangeResource;
import org.apache.baremaps.server.ClassPathResource;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.server.StyleResource;
import org.apache.baremaps.utils.ObjectMapperUtils;
import org.apache.baremaps.vectortile.style.Style;
import org.apache.baremaps.vectortile.style.StyleSource;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="style", description={"Start a development server with live reload for editing styles. Overrides the style sources."})
public class StyleCommand
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(StyleCommand.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--tiles"}, paramLabel="TILES", description={"The tiles url."}, required=true)
    private URL tilesUrl;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path stylePath;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        ConfigReader configReader = new ConfigReader();
        ObjectMapper objectMapper = ObjectMapperUtils.objectMapper();
        TypeLiteral<Supplier<Style>> styleSupplierType = new TypeLiteral<Supplier<Style>>(){};
        final Supplier<Style> styleSupplier = () -> {
            try {
                String config = configReader.read(this.stylePath);
                Style object = (Style)objectMapper.readValue(config, Style.class);
                StyleSource styleSource = new StyleSource("vector", this.tilesUrl.toString());
                object.setSources(Map.of("baremaps", styleSource));
                return object;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        ResourceConfig application = new ResourceConfig().register(CorsFilter.class).register(ChangeResource.class).register(StyleResource.class).register(ChangeResource.class).register(ClassPathResource.class).register((Object)ServiceTalkJacksonSerializerFeature.newContextResolver((ObjectMapper)objectMapper)).register((Object)new AbstractBinder(styleSupplierType){
            final /* synthetic */ 1 val$styleSupplierType;
            {
                this.val$styleSupplierType = var3_3;
            }

            protected void configure() {
                this.bind("assets").to(String.class).named("directory");
                this.bind("viewer.html").to(String.class).named("index");
                this.bind(StyleCommand.this.stylePath).to(Path.class).named("style");
                this.bind(styleSupplier).to((TypeLiteral)this.val$styleSupplierType);
            }
        });
        BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
        HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
        logger.info("Listening on {}", (Object)serverContext.listenAddress());
        serverContext.awaitShutdown();
        return 0;
    }
}

