/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.stream;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.baremaps.stream.HoldingConsumer;

public class PartitionedSpliterator<T>
implements Spliterator<Stream<T>> {
    private final Spliterator<T> spliterator;
    private final int partitionSize;

    public PartitionedSpliterator(Spliterator<T> spliterator, int partitionSize) {
        this.spliterator = spliterator;
        this.partitionSize = partitionSize;
    }

    @Override
    public boolean tryAdvance(Consumer<? super Stream<T>> action) {
        int size;
        Stream.Builder partition = Stream.builder();
        for (size = 0; size < this.partitionSize; ++size) {
            if (!this.spliterator.tryAdvance(partition::add)) break;
        }
        if (size == 0) {
            return false;
        }
        action.accept(partition.build());
        return true;
    }

    @Override
    public Spliterator<Stream<T>> trySplit() {
        HoldingConsumer consumer = new HoldingConsumer();
        this.tryAdvance(consumer);
        return Stream.ofNullable((Stream)consumer.value()).spliterator();
    }

    @Override
    public long estimateSize() {
        return this.spliterator.estimateSize() / (long)this.partitionSize;
    }

    @Override
    public int characteristics() {
        return this.spliterator.characteristics();
    }
}

