/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.shapefile;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.apache.baremaps.database.schema.DataSchema;
import org.apache.baremaps.database.schema.DataTable;
import org.apache.baremaps.database.schema.DataTableException;
import org.apache.baremaps.storage.shapefile.ShapefileDataTable;

public class ShapefileDataSchema
implements DataSchema {
    private final Path directory;

    public ShapefileDataSchema(Path directory) {
        this.directory = directory;
    }

    @Override
    public Collection<String> list() {
        List<String> list;
        block8: {
            Stream<Path> files = Files.list(this.directory);
            try {
                list = files.filter(file -> file.toString().toLowerCase().endsWith(".shp")).map(file -> file.getFileName().toString()).toList();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new DataTableException(e);
                }
            }
            files.close();
        }
        return list;
    }

    @Override
    public DataTable get(String name) {
        return new ShapefileDataTable(this.directory.resolve(name));
    }

    @Override
    public void add(DataTable value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(String name) {
        throw new UnsupportedOperationException();
    }
}

