/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.postgres;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.baremaps.openstreetmap.model.Info;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.postgres.PostgresJsonbMapper;
import org.apache.baremaps.openstreetmap.repository.NodeRepository;
import org.apache.baremaps.openstreetmap.repository.RepositoryException;
import org.apache.baremaps.postgres.copy.CopyWriter;
import org.apache.baremaps.utils.GeometryUtils;
import org.locationtech.jts.geom.Geometry;
import org.postgresql.PGConnection;
import org.postgresql.copy.PGCopyOutputStream;

public class PostgresNodeRepository
implements NodeRepository {
    private final DataSource dataSource;
    private final String createTable;
    private final String dropTable;
    private final String truncateTable;
    private final String select;
    private final String selectIn;
    private final String insert;
    private final String delete;
    private final String copy;

    public PostgresNodeRepository(DataSource dataSource) {
        this(dataSource, "osm_nodes", "id", "version", "uid", "timestamp", "changeset", "tags", "lon", "lat", "geom");
    }

    public PostgresNodeRepository(DataSource dataSource, String tableName, String idColumn, String versionColumn, String uidColumn, String timestampColumn, String changesetColumn, String tagsColumn, String longitudeColumn, String latitudeColumn, String geometryColumn) {
        this.dataSource = dataSource;
        this.createTable = String.format("CREATE TABLE %1$s\n(\n    %2$s bigint PRIMARY KEY,\n    %3$s int,\n    %4$s int,\n    %5$s timestamp without time zone,\n    %6$s bigint,\n    %7$s jsonb,\n    %8$s float,\n    %9$s float,\n    %10$s geometry(point)\n)", tableName, idColumn, versionColumn, uidColumn, timestampColumn, changesetColumn, tagsColumn, longitudeColumn, latitudeColumn, geometryColumn);
        this.dropTable = String.format("DROP TABLE IF EXISTS %1$s CASCADE", tableName);
        this.truncateTable = String.format("TRUNCATE TABLE %1$s", tableName);
        this.select = String.format("SELECT %2$s, %3$s, %4$s, %5$s, %6$s, %7$s, %8$s, %9$s, st_asbinary(%10$s) FROM %1$s WHERE %2$s = ?", tableName, idColumn, versionColumn, uidColumn, timestampColumn, changesetColumn, tagsColumn, longitudeColumn, latitudeColumn, geometryColumn);
        this.selectIn = String.format("SELECT %2$s, %3$s, %4$s, %5$s, %6$s, %7$s, %8$s, %9$s, st_asbinary(%10$s) FROM %1$s WHERE %2$s = ANY (?)", tableName, idColumn, versionColumn, uidColumn, timestampColumn, changesetColumn, tagsColumn, longitudeColumn, latitudeColumn, geometryColumn);
        this.insert = String.format("INSERT INTO %1$s (%2$s, %3$s, %4$s, %5$s, %6$s, %7$s, %8$s, %9$s, %10$s) VALUES (?, ? ,? , ?, ?, cast (? AS jsonb), ?, ?, ?)ON CONFLICT (%2$s) DO UPDATE SET %3$s = excluded.%3$s, %4$s = excluded.%4$s, %5$s = excluded.%5$s, %6$s = excluded.%6$s, %7$s = excluded.%7$s, %8$s = excluded.%8$s, %9$s = excluded.%9$s, %10$s = excluded.%10$s", tableName, idColumn, versionColumn, uidColumn, timestampColumn, changesetColumn, tagsColumn, longitudeColumn, latitudeColumn, geometryColumn);
        this.delete = String.format("DELETE FROM %1$s WHERE %2$s = ?", tableName, idColumn);
        this.copy = String.format("COPY %1$s (%2$s, %3$s, %4$s, %5$s, %6$s, %7$s, %8$s, %9$s, %10$s) FROM STDIN BINARY", tableName, idColumn, versionColumn, uidColumn, timestampColumn, changesetColumn, tagsColumn, longitudeColumn, latitudeColumn, geometryColumn);
    }

    @Override
    public void create() throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.createTable);){
            statement.execute();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void drop() throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.dropTable);){
            statement.execute();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void truncate() throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.truncateTable);){
            statement.execute();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Node get(Long key) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Node> get(List<Long> keys) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void put(Node value) throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.insert);){
            this.setValue(statement, value);
            statement.execute();
        }
        catch (JsonProcessingException | SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void put(List<Node> values) throws RepositoryException {
        if (values.isEmpty()) {
            return;
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.insert);){
            for (Node value : values) {
                statement.clearParameters();
                this.setValue(statement, value);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (JsonProcessingException | SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void delete(Long key) throws RepositoryException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.delete);){
            statement.setObject(1, key);
            statement.execute();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void delete(List<Long> keys) throws RepositoryException {
        if (keys.isEmpty()) {
            return;
        }
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.delete);){
            for (Long key : keys) {
                statement.clearParameters();
                statement.setObject(1, key);
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public void copy(List<Node> values) throws RepositoryException {
        if (values.isEmpty()) {
            return;
        }
        try (Connection connection = this.dataSource.getConnection();){
            PGConnection pgConnection = connection.unwrap(PGConnection.class);
            try (CopyWriter writer = new CopyWriter(new PGCopyOutputStream(pgConnection, this.copy));){
                writer.writeHeader();
                for (Node value : values) {
                    writer.startRow(9);
                    writer.writeLong(value.id());
                    writer.writeInteger(value.getInfo().getVersion());
                    writer.writeInteger(value.getInfo().getUid());
                    writer.writeLocalDateTime(value.getInfo().getTimestamp());
                    writer.writeLong(value.getInfo().getChangeset());
                    writer.writeJsonb(PostgresJsonbMapper.toJson(value.getTags()));
                    writer.writeDouble(value.getLon());
                    writer.writeDouble(value.getLat());
                    writer.writeGeometry(value.getGeometry());
                }
            }
        }
        catch (IOException | SQLException e) {
            throw new RepositoryException(e);
        }
    }

    private Node getValue(ResultSet resultSet) throws SQLException, JsonProcessingException {
        long id = resultSet.getLong(1);
        int version = resultSet.getInt(2);
        int uid = resultSet.getInt(3);
        LocalDateTime timestamp = resultSet.getObject(4, LocalDateTime.class);
        long changeset = resultSet.getLong(5);
        Map<String, Object> tags = PostgresJsonbMapper.toMap(resultSet.getString(6));
        double lon = resultSet.getDouble(7);
        double lat = resultSet.getDouble(8);
        Geometry point = GeometryUtils.deserialize(resultSet.getBytes(9));
        Info info = new Info(version, timestamp, changeset, uid);
        return new Node(id, info, tags, lon, lat, point);
    }

    private void setValue(PreparedStatement statement, Node value) throws SQLException, JsonProcessingException {
        statement.setObject(1, value.id());
        statement.setObject(2, value.getInfo().getVersion());
        statement.setObject(3, value.getInfo().getUid());
        statement.setObject(4, value.getInfo().getTimestamp());
        statement.setObject(5, value.getInfo().getChangeset());
        statement.setObject(6, PostgresJsonbMapper.toJson(value.getTags()));
        statement.setObject(7, value.getLon());
        statement.setObject(8, value.getLat());
        statement.setBytes(9, GeometryUtils.serialize(value.getGeometry()));
    }
}

