/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.database.type.DataType;

public class IntegerListDataType
implements DataType<List<Integer>> {
    @Override
    public int size(List<Integer> values) {
        return 4 + values.size() * 4;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Integer> values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (int value : values) {
            buffer.putInt(p, value);
            p += 4;
        }
    }

    @Override
    public List<Integer> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 4;
        ArrayList<Integer> values = new ArrayList<Integer>(length);
        for (int index = 0; index < length; ++index) {
            values.add(buffer.getInt(position + 4 + index * 4));
        }
        return values;
    }
}

