/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.wasm;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.wasm.ToJSValueNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyValueTypes;
import com.oracle.truffle.js.runtime.objects.Undefined;

@ExportLibrary(value=InteropLibrary.class)
public class WebAssemblyHostFunction
implements TruffleObject {
    private final Object fn;
    private final TruffleString returnType;
    private final boolean returnTypeIsI64;
    private final boolean anyArgTypeIsI64;

    public WebAssemblyHostFunction(JSContext context, Object fn, TruffleString typeInfo) {
        assert (JSRuntime.isCallable(fn));
        this.fn = fn;
        int idxOpen = Strings.indexOf(typeInfo, '(');
        int idxClose = Strings.indexOf(typeInfo, ')');
        this.returnType = Strings.substring(context, typeInfo, idxClose + 1);
        this.returnTypeIsI64 = JSWebAssemblyValueTypes.isI64(this.returnType);
        this.anyArgTypeIsI64 = Strings.indexOf(typeInfo, JSWebAssemblyValueTypes.I64, idxOpen + 1, idxClose) >= 0;
    }

    @ExportMessage
    public static final boolean isExecutable(WebAssemblyHostFunction receiver) {
        return true;
    }

    @ExportMessage
    public final Object execute(Object[] args, @Cached ToWebAssemblyValueNode toWebAssemblyValueNode, @Cached ToJSValueNode toJSValueNode, @Cached(value="createCall()", uncached="getUncachedCall()") JSFunctionCallNode callNode, @Cached BranchProfile errorBranch, @CachedLibrary(value="this") InteropLibrary self) {
        if (!JavaScriptLanguage.get((Node)self).getJSContext().getContextOptions().isWasmBigInt() && (this.returnTypeIsI64 || this.anyArgTypeIsI64)) {
            errorBranch.enter();
            throw Errors.createTypeError("wasm function signature contains illegal type");
        }
        Object[] jsArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            jsArgs[i] = toJSValueNode.execute(args[i]);
        }
        Object result = callNode.executeCall(JSArguments.create((Object)Undefined.instance, this.fn, jsArgs));
        if (this.returnType.isEmpty()) {
            return Undefined.instance;
        }
        return toWebAssemblyValueNode.execute(result, this.returnType);
    }
}

