/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import java.util.List;
import java.util.Map;
import org.apache.amoro.api.ServerTableIdentifier;
import org.apache.amoro.api.metrics.Counter;
import org.apache.amoro.api.metrics.Gauge;
import org.apache.amoro.api.metrics.Metric;
import org.apache.amoro.api.metrics.MetricDefine;
import org.apache.amoro.api.metrics.MetricKey;
import org.apache.amoro.server.metrics.MetricRegistry;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.OptimizingType;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;

public class TableOptimizingMetrics {
    public static final String STATUS_IDLE = "idle";
    public static final String STATUS_PENDING = "pending";
    public static final String STATUS_PLANING = "planing";
    public static final String STATUS_EXECUTING = "executing";
    public static final String STATUS_COMMITTING = "committing";
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IDLE_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_idle_duration_mills").withDescription("Duration in milliseconds after table be in idle status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_PENDING_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_pending_duration_mills").withDescription("Duration in milliseconds after table be in pending status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_PLANNING_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_planning_duration_mills").withDescription("Duration in milliseconds after table be in planning status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_EXECUTING_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_executing_duration_mills").withDescription("Duration in milliseconds after table be in executing status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_COMMITTING_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_committing_duration_mills").withDescription("Duration in milliseconds after table be in committing status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_PROCESS_TOTAL_COUNT = MetricDefine.defineCounter((String)"table_optimizing_process_total_count").withDescription("Count of all optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_PROCESS_FAILED_COUNT = MetricDefine.defineCounter((String)"table_optimizing_process_failed_count").withDescription("Count of failed optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_MINOR_TOTAL_COUNT = MetricDefine.defineCounter((String)"table_optimizing_minor_total_count").withDescription("Count of minor optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_MINOR_FAILED_COUNT = MetricDefine.defineCounter((String)"table_optimizing_minor_failed_count").withDescription("Count of failed minor optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_MAJOR_TOTAL_COUNT = MetricDefine.defineCounter((String)"table_optimizing_major_total_count").withDescription("Count of major optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_MAJOR_FAILED_COUNT = MetricDefine.defineCounter((String)"table_optimizing_major_failed_count").withDescription("Count of failed major optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_FULL_TOTAL_COUNT = MetricDefine.defineCounter((String)"table_optimizing_full_total_count").withDescription("Count of full optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_FULL_FAILED_COUNT = MetricDefine.defineCounter((String)"table_optimizing_full_failed_count").withDescription("Count of failed full optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_IDLE = MetricDefine.defineGauge((String)"table_optimizing_status_in_idle").withDescription("If currently table is in idle status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_PENDING = MetricDefine.defineGauge((String)"table_optimizing_status_in_pending").withDescription("If currently table is in pending status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_PLANNING = MetricDefine.defineGauge((String)"table_optimizing_status_in_planning").withDescription("If currently table is in planning status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_EXECUTING = MetricDefine.defineGauge((String)"table_optimizing_status_in_executing").withDescription("If currently table is in executing status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_COMMITTING = MetricDefine.defineGauge((String)"table_optimizing_status_in_committing").withDescription("If currently table is in committing status").withTags(new String[]{"catalog", "database", "table"}).build();
    private final Counter processTotalCount = new Counter();
    private final Counter processFailedCount = new Counter();
    private final Counter minorTotalCount = new Counter();
    private final Counter minorFailedCount = new Counter();
    private final Counter majorTotalCount = new Counter();
    private final Counter majorFailedCount = new Counter();
    private final Counter fullTotalCount = new Counter();
    private final Counter fullFailedCount = new Counter();
    private final ServerTableIdentifier identifier;
    private OptimizingStatus optimizingStatus = OptimizingStatus.IDLE;
    private long statusSetTimestamp = System.currentTimeMillis();
    private final List<MetricKey> registeredMetricKeys = Lists.newArrayList();
    private MetricRegistry globalRegistry;

    public TableOptimizingMetrics(ServerTableIdentifier identifier) {
        this.identifier = identifier;
    }

    private void registerMetric(MetricRegistry registry, MetricDefine define, Metric metric) {
        MetricKey key = registry.register(define, (Map<String, String>)ImmutableMap.of((Object)"catalog", (Object)this.identifier.getCatalog(), (Object)"database", (Object)this.identifier.getDatabase(), (Object)"table", (Object)this.identifier.getTableName()), metric);
        this.registeredMetricKeys.add(key);
    }

    public void register(MetricRegistry registry) {
        if (this.globalRegistry == null) {
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IDLE_DURATION, (Metric)new StatusDurationGauge(STATUS_IDLE));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_PENDING_DURATION, (Metric)new StatusDurationGauge(STATUS_PENDING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_PLANNING_DURATION, (Metric)new StatusDurationGauge(STATUS_PLANING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_EXECUTING_DURATION, (Metric)new StatusDurationGauge(STATUS_EXECUTING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_COMMITTING_DURATION, (Metric)new StatusDurationGauge(STATUS_COMMITTING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_IDLE, (Metric)new IsInStatusGauge(STATUS_IDLE));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_PENDING, (Metric)new IsInStatusGauge(STATUS_PENDING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_PLANNING, (Metric)new IsInStatusGauge(STATUS_PLANING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_EXECUTING, (Metric)new IsInStatusGauge(STATUS_EXECUTING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_COMMITTING, (Metric)new IsInStatusGauge(STATUS_COMMITTING));
            this.registerMetric(registry, TABLE_OPTIMIZING_PROCESS_TOTAL_COUNT, (Metric)this.processTotalCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_PROCESS_FAILED_COUNT, (Metric)this.processFailedCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_MINOR_TOTAL_COUNT, (Metric)this.minorTotalCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_MINOR_FAILED_COUNT, (Metric)this.minorFailedCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_MAJOR_TOTAL_COUNT, (Metric)this.majorTotalCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_MAJOR_FAILED_COUNT, (Metric)this.majorFailedCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_FULL_TOTAL_COUNT, (Metric)this.fullTotalCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_FULL_FAILED_COUNT, (Metric)this.fullFailedCount);
            this.globalRegistry = registry;
        }
    }

    public void unregister() {
        this.registeredMetricKeys.forEach(this.globalRegistry::unregister);
        this.registeredMetricKeys.clear();
        this.globalRegistry = null;
    }

    public void statusChanged(OptimizingStatus optimizingStatus, long statusSetTimestamp) {
        this.optimizingStatus = optimizingStatus;
        this.statusSetTimestamp = statusSetTimestamp;
    }

    public void processComplete(OptimizingType processType, boolean success) {
        this.processTotalCount.inc();
        Counter totalCounter = null;
        Counter failedCounter = null;
        switch (processType) {
            case MINOR: {
                totalCounter = this.minorTotalCount;
                failedCounter = this.minorFailedCount;
                break;
            }
            case MAJOR: {
                totalCounter = this.majorTotalCount;
                failedCounter = this.majorFailedCount;
                break;
            }
            case FULL: {
                totalCounter = this.fullTotalCount;
                failedCounter = this.fullFailedCount;
            }
        }
        if (totalCounter != null) {
            totalCounter.inc();
        }
        if (!success && failedCounter != null) {
            failedCounter.inc();
        }
    }

    private String getOptimizingStatusDesc(OptimizingStatus status) {
        switch (status) {
            case IDLE: {
                return STATUS_IDLE;
            }
            case PENDING: {
                return STATUS_PENDING;
            }
            case PLANNING: {
                return STATUS_PLANING;
            }
            case FULL_OPTIMIZING: 
            case MAJOR_OPTIMIZING: 
            case MINOR_OPTIMIZING: {
                return STATUS_EXECUTING;
            }
            case COMMITTING: {
                return STATUS_COMMITTING;
            }
        }
        return status.name();
    }

    class IsInStatusGauge
    implements Gauge<Long> {
        final String targetStatus;

        IsInStatusGauge(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        public Long getValue() {
            String status = TableOptimizingMetrics.this.getOptimizingStatusDesc(TableOptimizingMetrics.this.optimizingStatus);
            if (this.targetStatus.equals(status)) {
                return 1L;
            }
            return 0L;
        }
    }

    class StatusDurationGauge
    implements Gauge<Long> {
        final String targetStatus;

        StatusDurationGauge(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        public Long getValue() {
            String status = TableOptimizingMetrics.this.getOptimizingStatusDesc(TableOptimizingMetrics.this.optimizingStatus);
            if (this.targetStatus.equals(status)) {
                return this.statusDuration();
            }
            return 0L;
        }

        private Long statusDuration() {
            return System.currentTimeMillis() - TableOptimizingMetrics.this.statusSetTimestamp;
        }
    }
}

