/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.amoro.api.StateField;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;

public abstract class StatedPersistentBase
extends PersistentBase {
    private static final Map<Class<? extends PersistentBase>, Field[]> metaCache = Maps.newConcurrentMap();
    private static final Object NULL_VALUE = new Object();
    private final Lock stateLock = new ReentrantLock();
    private final Field[] consistentFields = this.getOrCreateConsistentFields();

    protected StatedPersistentBase() {
    }

    protected final void invokeConsistency(Runnable runnable) {
        this.stateLock.lock();
        Map<Field, Object> states = this.retainStates();
        try {
            this.doAsTransaction(runnable);
        }
        catch (Throwable throwable) {
            this.restoreStates(states);
            throw throwable;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    protected final <T> T invokeConsistency(Supplier<T> supplier) {
        this.stateLock.lock();
        Map<Field, Object> states = this.retainStates();
        try {
            T t = supplier.get();
            return t;
        }
        catch (Throwable throwable) {
            this.restoreStates(states);
            throw throwable;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    protected final void invokeInStateLock(Runnable runnable) {
        this.stateLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    Map<Field, Object> retainStates() {
        return Arrays.stream(this.consistentFields).collect(Collectors.toMap(field -> field, this::getValue));
    }

    void restoreStates(Map<Field, Object> statesMap) {
        statesMap.forEach(this::setValue);
    }

    private Field[] getOrCreateConsistentFields() {
        return metaCache.computeIfAbsent(this.getClass(), clz -> {
            ArrayList fields = new ArrayList();
            while (clz != PersistentBase.class) {
                Arrays.stream(clz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(StateField.class)).forEach(fields::add);
                clz = clz.getSuperclass().asSubclass(PersistentBase.class);
            }
            return fields.toArray(new Field[0]);
        });
    }

    private Object getValue(Field field) {
        try {
            field.setAccessible(true);
            return Optional.ofNullable(field.get(this)).orElse(NULL_VALUE);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    void setValue(Field field, Object value) {
        try {
            field.set(this, NULL_VALUE.equals(value) ? null : value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

