/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.time.Duration;
import javax.sql.DataSource;
import org.apache.amoro.api.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.persistence.mapper.ApiTokensMapper;
import org.apache.amoro.server.persistence.mapper.CatalogMetaMapper;
import org.apache.amoro.server.persistence.mapper.OptimizerMapper;
import org.apache.amoro.server.persistence.mapper.OptimizingMapper;
import org.apache.amoro.server.persistence.mapper.PlatformFileMapper;
import org.apache.amoro.server.persistence.mapper.ResourceMapper;
import org.apache.amoro.server.persistence.mapper.TableBlockerMapper;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;

public class SqlSessionFactoryProvider {
    private static final String DERBY_INIT_SQL_SCRIPT = "derby/ams-derby-init.sql";
    private static final String MYSQL_INIT_SQL_SCRIPT = "mysql/ams-mysql-init.sql";
    private static final String POSTGRES_INIT_SQL_SCRIPT = "postgres/ams-postgres-init.sql";
    private static final SqlSessionFactoryProvider INSTANCE = new SqlSessionFactoryProvider();
    private static String dbType;
    private volatile SqlSessionFactory sqlSessionFactory;

    public static SqlSessionFactoryProvider getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Configurations config) {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUrl(config.getString(AmoroManagementConf.DB_CONNECTION_URL));
        dataSource.setDriverClassName(config.getString(AmoroManagementConf.DB_DRIVER_CLASS_NAME));
        dbType = config.getString(AmoroManagementConf.DB_TYPE);
        if ("mysql".equals(dbType) || "postgres".equals(dbType)) {
            dataSource.setUsername(config.getString(AmoroManagementConf.DB_USER_NAME));
            dataSource.setPassword(config.getString(AmoroManagementConf.DB_PASSWORD));
        }
        dataSource.setDefaultAutoCommit(Boolean.valueOf(false));
        dataSource.setMaxTotal(config.getInteger(AmoroManagementConf.DB_CONNECT_MAX_TOTAL));
        dataSource.setMaxIdle(config.getInteger(AmoroManagementConf.DB_CONNECT_MAX_IDLE));
        dataSource.setMinIdle(0);
        dataSource.setMaxWaitMillis(config.getLong(AmoroManagementConf.DB_CONNECT_MAX_WAIT_MILLIS));
        dataSource.setLogAbandoned(true);
        dataSource.setRemoveAbandonedOnBorrow(true);
        dataSource.setRemoveAbandonedTimeout(60);
        dataSource.setTimeBetweenEvictionRunsMillis(Duration.ofMillis(600000L).toMillis());
        dataSource.setTestOnBorrow(false);
        dataSource.setTestWhileIdle(false);
        dataSource.setMinEvictableIdleTimeMillis(1000L);
        dataSource.setNumTestsPerEvictionRun(3);
        dataSource.setTestOnReturn(false);
        dataSource.setSoftMinEvictableIdleTimeMillis(BaseObjectPoolConfig.DEFAULT_SOFT_MIN_EVICTABLE_IDLE_TIME.toMillis());
        dataSource.setLifo(true);
        JdbcTransactionFactory transactionFactory = new JdbcTransactionFactory();
        Environment environment = new Environment("develop", (TransactionFactory)transactionFactory, (DataSource)dataSource);
        Configuration configuration = new Configuration(environment);
        configuration.addMapper(TableMetaMapper.class);
        configuration.addMapper(OptimizingMapper.class);
        configuration.addMapper(CatalogMetaMapper.class);
        configuration.addMapper(OptimizerMapper.class);
        configuration.addMapper(ApiTokensMapper.class);
        configuration.addMapper(PlatformFileMapper.class);
        configuration.addMapper(ResourceMapper.class);
        configuration.addMapper(TableBlockerMapper.class);
        if (this.sqlSessionFactory == null) {
            SqlSessionFactoryProvider sqlSessionFactoryProvider = this;
            synchronized (sqlSessionFactoryProvider) {
                if (this.sqlSessionFactory == null) {
                    this.sqlSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
                }
            }
        }
        this.createTablesIfNeed(config);
    }

    private void createTablesIfNeed(Configurations config) {
        String dbTypeConfig = config.getString(AmoroManagementConf.DB_TYPE);
        String query = "";
        try (SqlSession sqlSession = this.get().openSession(true);
             Connection connection = sqlSession.getConnection();
             Statement statement = connection.createStatement();){
            if ("derby".equals(dbTypeConfig)) {
                query = "SELECT 1 FROM SYS.SYSTABLES WHERE TABLENAME = 'CATALOG_METADATA'";
            } else if ("mysql".equals(dbTypeConfig)) {
                query = String.format("SELECT 1 FROM information_schema.tables WHERE table_schema = '%s' AND table_name = '%s'", connection.getCatalog(), "catalog_metadata");
            } else if ("postgres".equals(dbTypeConfig)) {
                query = String.format("SELECT 1 FROM information_schema.tables WHERE table_schema = %s AND table_name = '%s'", "current_schema()", "catalog_metadata");
            }
            try (ResultSet rs = statement.executeQuery(query);){
                if (!rs.next()) {
                    ScriptRunner runner = new ScriptRunner(connection);
                    runner.runScript((Reader)new InputStreamReader(Files.newInputStream(Paths.get(this.getInitSqlScriptPath(dbTypeConfig)), new OpenOption[0]), StandardCharsets.UTF_8));
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Create tables failed", e);
        }
    }

    private URI getInitSqlScriptPath(String type) throws URISyntaxException {
        String scriptPath = null;
        if (type.equals("mysql")) {
            scriptPath = MYSQL_INIT_SQL_SCRIPT;
        } else if (type.equals("derby")) {
            scriptPath = DERBY_INIT_SQL_SCRIPT;
        } else if (type.equals("postgres")) {
            scriptPath = POSTGRES_INIT_SQL_SCRIPT;
        }
        URL scriptUrl = ClassLoader.getSystemResource(scriptPath);
        if (scriptUrl == null) {
            throw new IllegalStateException("Cannot find init sql script:" + scriptPath);
        }
        return scriptUrl.toURI();
    }

    public SqlSessionFactory get() {
        Preconditions.checkState((this.sqlSessionFactory != null ? 1 : 0) != 0, (Object)"Persistent configuration is not initialized yet.");
        return this.sqlSessionFactory;
    }

    public static String getDbType() {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)dbType), (Object)"Persistent configuration is not initialized yet.");
        return dbType;
    }
}

