/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.api;

import java.util.Collections;
import java.util.Set;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;

public enum Action {
    MINOR_OPTIMIZING("minor-optimizing", 0),
    MAJOR_OPTIMIZING("major-optimizing", 1),
    EXTERNAL_OPTIMIZING("external-optimizing", 2),
    REFRESH_METADATA("refresh-metadata", 10),
    EXPIRE_DATA("expire-data", 11),
    DELETE_ORPHAN_FILES("delete-orphan-files", 12),
    SYNC_HIVE_COMMIT("sync-hive-commit", 13);

    public static final Set<Action> ARBITRARY_ACTIONS;
    private final String description;
    private final int code;

    public static boolean isArbitrary(Action action) {
        return ARBITRARY_ACTIONS.contains((Object)action);
    }

    private Action(String description, int dbValue) {
        this.description = description;
        this.code = dbValue;
    }

    public String getDescription() {
        return this.description;
    }

    public int getCode() {
        return this.code;
    }

    public static Action of(int code) {
        for (Action action : Action.values()) {
            if (action.code != code) continue;
            return action;
        }
        throw new IllegalArgumentException("No action with code: " + code);
    }

    static {
        ARBITRARY_ACTIONS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Action[]{REFRESH_METADATA, EXPIRE_DATA, DELETE_ORPHAN_FILES, SYNC_HIVE_COMMIT}));
    }
}

