/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.writer;

import java.io.IOException;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.shade.org.apache.parquet.hadoop.ParquetWriter;
import org.apache.paimon.utils.Preconditions;

public class ParquetBulkWriter
implements FormatWriter {
    private final ParquetWriter<InternalRow> parquetWriter;

    public ParquetBulkWriter(ParquetWriter<InternalRow> parquetWriter) {
        this.parquetWriter = Preconditions.checkNotNull(parquetWriter, "parquetWriter");
    }

    @Override
    public void addElement(InternalRow datum) throws IOException {
        this.parquetWriter.write(datum);
    }

    @Override
    public void flush() {
    }

    @Override
    public void finish() throws IOException {
        this.parquetWriter.close();
    }

    @Override
    public boolean reachTargetSize(boolean suggestedCheck, long targetSize) throws IOException {
        return suggestedCheck && this.parquetWriter.getDataSize() >= targetSize;
    }
}

