/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.messages;

import org.apache.flink.runtime.rpc.messages.Message;

public interface RpcInvocation
extends Message {
    public String getMethodName();

    public Class<?>[] getParameterTypes();

    public Object[] getArgs();

    public static String convertRpcToString(String declaringClassName, String methodName, Class<?>[] parameterTypes) {
        StringBuilder paramTypeStringBuilder = new StringBuilder(parameterTypes.length * 5);
        if (parameterTypes.length > 0) {
            paramTypeStringBuilder.append(parameterTypes[0].getSimpleName());
            for (int i = 1; i < parameterTypes.length; ++i) {
                paramTypeStringBuilder.append(", ").append(parameterTypes[i].getSimpleName());
            }
        }
        return declaringClassName + '.' + methodName + '(' + paramTypeStringBuilder + ')';
    }
}

