/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.hilbert;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import org.davidmoten.hilbert.Box;
import org.davidmoten.hilbert.HilbertCurve;
import org.davidmoten.hilbert.Range;
import org.davidmoten.hilbert.Ranges;
import org.davidmoten.hilbert.Util;

public final class SmallHilbertCurve {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final int bits;
    private final int dimensions;
    private final int length;

    private SmallHilbertCurve(int bits, int dimensions) {
        this.bits = bits;
        this.dimensions = dimensions;
        this.length = bits * dimensions;
    }

    public int bits() {
        return this.bits;
    }

    public int dimensions() {
        return this.dimensions;
    }

    public long index(long ... point) {
        Preconditions.checkArgument((point.length == this.dimensions ? 1 : 0) != 0);
        return this.toIndex(HilbertCurve.transposedIndex(this.bits, point));
    }

    public long[] point(long index) {
        return HilbertCurve.transposedIndexToPoint(this.bits, this.transposeLong(index));
    }

    public void point(long index, long[] x) {
        Util.zero(x);
        this.transposeLong(index, x);
        HilbertCurve.transposedIndexToPoint(this.bits, x);
    }

    private long toIndex(long ... transposedIndex) {
        long b = 0L;
        int bIndex = this.length - 1;
        long mask = 1L << this.bits - 1;
        for (int i = 0; i < this.bits; ++i) {
            for (int j = 0; j < transposedIndex.length; ++j) {
                if ((transposedIndex[j] & mask) != 0L) {
                    b |= 1L << bIndex;
                }
                --bIndex;
            }
            mask >>= 1;
        }
        return b;
    }

    private void transposeLong(long index, long[] x) {
        for (int idx = 0; idx < 64; ++idx) {
            if ((index & 1L << idx) == 0L) continue;
            int dim = (this.length - idx - 1) % this.dimensions;
            int shift = idx / this.dimensions % this.bits;
            int n = dim;
            x[n] = x[n] | 1L << shift;
        }
    }

    private long[] transposeLong(long index) {
        long[] x = new long[this.dimensions];
        this.transposeLong(index, x);
        return x;
    }

    public long maxOrdinate() {
        return (1 << this.bits) - 1;
    }

    public long maxIndex() {
        return (1 << this.bits * this.dimensions) - 1;
    }

    public Ranges query(long[] a, long[] b) {
        return this.query(a, b, 0, 0);
    }

    public Ranges query(long[] a, long[] b, int maxRanges) {
        if (maxRanges == 0) {
            return this.query(a, b, 0, 0);
        }
        return this.query(a, b, maxRanges, Math.max(1024, maxRanges));
    }

    public Ranges query(long[] a, long[] b, int maxRanges, int bufferSize) {
        Preconditions.checkArgument((maxRanges >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((bufferSize >= maxRanges ? 1 : 0) != 0, (String)"bufferSize must be greater than or equal to maxRanges");
        if (maxRanges == 0) {
            bufferSize = 0;
        }
        Box box = new Box(a, b);
        ArrayList list = new ArrayList();
        box.visitPerimeter(cell -> {
            long n = this.index((long)cell);
            list.add(n);
        });
        Collections.sort(list);
        int i = 0;
        Ranges ranges = new Ranges(bufferSize);
        long rangeStart = -1L;
        while (i != list.size()) {
            if (rangeStart == -1L) {
                rangeStart = (Long)list.get(i);
            }
            while (i < list.size() - 1 && (Long)list.get(i + 1) == (Long)list.get(i) + 1L) {
                ++i;
            }
            if (i == list.size() - 1) {
                ranges.add(Range.create(rangeStart, (Long)list.get(i)));
                break;
            }
            long[] point = this.point((Long)list.get(i) + 1L);
            if (box.contains(point)) {
                ++i;
                continue;
            }
            ranges.add(Range.create(rangeStart, (Long)list.get(i)));
            rangeStart = -1L;
            ++i;
        }
        if (ranges.size() <= maxRanges) {
            return ranges;
        }
        Ranges r = new Ranges(maxRanges);
        for (Range range : ranges) {
            r.add(range);
        }
        return r;
    }

    public static final class Builder {
        private int bits;

        Builder() {
        }

        public Builder bits(int bits) {
            this.bits = bits;
            return this;
        }

        public SmallHilbertCurve dimensions(int dimensions) {
            Preconditions.checkArgument((this.bits * dimensions <= 63 ? 1 : 0) != 0, (String)"bits * dimensions must be less than or equal to 63");
            return new SmallHilbertCurve(this.bits, dimensions);
        }
    }
}

