/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.compute.JobExecution;
import org.apache.ignite3.compute.JobState;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.SharedComputeUtils;
import org.apache.ignite3.internal.hlc.HybridTimestampTracker;
import org.apache.ignite3.internal.lang.IgniteBiTuple;
import org.apache.ignite3.marshalling.Marshaller;
import org.apache.ignite3.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class ResultUnmarshallingJobExecution<R>
implements JobExecution<R> {
    private final JobExecution<ComputeJobDataHolder> delegate;
    @Nullable
    private final Marshaller<R, byte[]> resultUnmarshaller;
    @Nullable
    private final Class<R> resultClass;
    private final HybridTimestampTracker observableTimestampTracker;

    ResultUnmarshallingJobExecution(JobExecution<ComputeJobDataHolder> delegate, @Nullable Marshaller<R, byte[]> resultUnmarshaller, @Nullable Class<R> resultClass, HybridTimestampTracker observableTimestampTracker) {
        this.delegate = delegate;
        this.resultUnmarshaller = resultUnmarshaller;
        this.resultClass = resultClass;
        this.observableTimestampTracker = observableTimestampTracker;
    }

    @Override
    public CompletableFuture<R> resultAsync() {
        return this.delegate.resultAsync().thenApply(r -> {
            this.updateTimestamp((ComputeJobDataHolder)r);
            return SharedComputeUtils.unmarshalArgOrResult(r, this.resultUnmarshaller, this.resultClass);
        });
    }

    @Override
    public CompletableFuture<@Nullable JobState> stateAsync() {
        return this.delegate.stateAsync();
    }

    @Override
    public CompletableFuture<@Nullable Boolean> changePriorityAsync(int newPriority) {
        return this.delegate.changePriorityAsync(newPriority);
    }

    @Override
    public ClusterNode node() {
        return this.delegate.node();
    }

    public CompletableFuture<IgniteBiTuple<R, Long>> resultWithTimestampAsync() {
        return this.delegate.resultAsync().thenApply(r -> {
            this.updateTimestamp((ComputeJobDataHolder)r);
            return new IgniteBiTuple(SharedComputeUtils.unmarshalArgOrResult(r, this.resultUnmarshaller, this.resultClass), r.observableTimestamp());
        });
    }

    private void updateTimestamp(ComputeJobDataHolder r) {
        Long ts = r.observableTimestamp();
        assert (ts != null) : "Job result observable timestamp should not be null";
        this.observableTimestampTracker.update(ts);
    }
}

