/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format;

import java.time.format.TextStyle;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.CapitalizationEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.FormatPattern;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;
import org.apache.calcite.util.format.postgresql.format.compiled.DayOfWeekCompiledPattern;

public class DayOfWeekFormatPattern
extends FormatPattern {
    private final CapitalizationEnum capitalization;
    private final TextStyle textStyle;

    public DayOfWeekFormatPattern(String pattern) {
        super(pattern);
        switch (pattern) {
            case "DAY": {
                this.capitalization = CapitalizationEnum.ALL_UPPER;
                this.textStyle = TextStyle.FULL;
                break;
            }
            case "Day": {
                this.capitalization = CapitalizationEnum.CAPITALIZED;
                this.textStyle = TextStyle.FULL;
                break;
            }
            case "day": {
                this.capitalization = CapitalizationEnum.ALL_LOWER;
                this.textStyle = TextStyle.FULL;
                break;
            }
            case "DY": {
                this.capitalization = CapitalizationEnum.ALL_UPPER;
                this.textStyle = TextStyle.SHORT;
                break;
            }
            case "Dy": {
                this.capitalization = CapitalizationEnum.CAPITALIZED;
                this.textStyle = TextStyle.SHORT;
                break;
            }
            default: {
                this.capitalization = CapitalizationEnum.ALL_LOWER;
                this.textStyle = TextStyle.SHORT;
            }
        }
    }

    @Override
    protected CompiledPattern buildCompiledPattern(Set<PatternModifier> modifiers) {
        return new DayOfWeekCompiledPattern(modifiers, this.capitalization, this.textStyle);
    }
}

