/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.cluster;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.jetbrains.annotations.Nullable;

public class ClientClusterGetNodesRequest {
    @Nullable
    public static CompletableFuture<Void> process(ClientMessagePacker out, ClusterService clusterService) {
        Collection nodes = clusterService.topologyService().allMembers();
        out.packInt(nodes.size());
        for (ClusterNode node : nodes) {
            ClientClusterGetNodesRequest.packClusterNode(node, out);
        }
        return null;
    }

    public static void packClusterNode(ClusterNode clusterNode, ClientMessagePacker out) {
        out.packInt(4);
        out.packUuid(clusterNode.id());
        out.packString(clusterNode.name());
        NetworkAddress address = clusterNode.address();
        out.packString(address.host());
        out.packInt(address.port());
    }
}

