/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite.internal.tx.message.TxCleanupMessage;
import org.apache.ignite.internal.tx.message.TxCleanupMessageBuilder;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class TxCleanupMessageDeserializer
implements MessageDeserializer<TxCleanupMessage> {
    private final TxCleanupMessageBuilder msg;

    TxCleanupMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txCleanupMessage();
    }

    public Class<TxCleanupMessage> klass() {
        return TxCleanupMessage.class;
    }

    public TxCleanupMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("commit");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commit(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTimestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readList("groups", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groups((List<TablePartitionIdMessage>)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxCleanupMessage.class);
    }
}

