/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.impl;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.IgniteBiTuple;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.placementdriver.PlacementDriver;
import org.apache.ignite.internal.placementdriver.ReplicaMeta;
import org.apache.ignite.internal.replicator.ReplicationGroupId;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.tx.MismatchingTransactionOutcomeInternalException;
import org.apache.ignite.internal.tx.TransactionResult;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.impl.PrimaryReplicaExpiredException;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class TransactionInflights {
    private static final int MAX_CONCURRENT_TXNS = 1024;
    private final ConcurrentHashMap<UUID, TxContext> txCtxMap = new ConcurrentHashMap(1024);
    private final PlacementDriver placementDriver;
    private final ClockService clockService;

    public TransactionInflights(PlacementDriver placementDriver, ClockService clockService) {
        this.placementDriver = placementDriver;
        this.clockService = clockService;
    }

    public boolean addInflight(UUID txId, boolean readOnly) {
        boolean[] res = new boolean[]{true};
        this.txCtxMap.compute(txId, (uuid, ctx) -> {
            if (ctx == null) {
                ctx = readOnly ? new ReadOnlyTxContext() : new ReadWriteTxContext(this.placementDriver, this.clockService);
            }
            res[0] = ctx.addInflight();
            return ctx;
        });
        return res[0];
    }

    public void removeInflight(UUID txId) {
        TxContext tuple = this.txCtxMap.computeIfPresent(txId, (uuid, ctx) -> {
            ctx.removeInflight(txId);
            return ctx;
        });
        if (tuple != null) {
            tuple.onInflightsRemoved();
        }
    }

    Collection<UUID> finishedReadOnlyTransactions() {
        return this.txCtxMap.entrySet().stream().filter(e -> e.getValue() instanceof ReadOnlyTxContext && ((TxContext)e.getValue()).isReadyToFinish()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    void removeTxContext(UUID txId) {
        this.txCtxMap.remove(txId);
    }

    void removeTxContexts(Collection<UUID> txIds) {
        ((ConcurrentHashMap.KeySetView)this.txCtxMap.keySet()).removeAll((Collection)txIds);
    }

    void cancelWaitingInflights(TablePartitionId groupId) {
        for (Map.Entry<UUID, TxContext> ctxEntry : this.txCtxMap.entrySet()) {
            IgniteBiTuple<ClusterNode, Long> nodeAndToken;
            ReadWriteTxContext txContext;
            if (!(ctxEntry.getValue() instanceof ReadWriteTxContext) || !(txContext = (ReadWriteTxContext)ctxEntry.getValue()).isTxFinishing() || (nodeAndToken = txContext.enlistedGroups.get(groupId)) == null) continue;
            txContext.cancelWaitingInflights(groupId, (Long)nodeAndToken.get2());
        }
    }

    void markReadOnlyTxFinished(UUID txId) {
        this.txCtxMap.compute(txId, (k, ctx) -> {
            if (ctx == null) {
                ctx = new ReadOnlyTxContext();
            }
            ctx.finishTx(null);
            return ctx;
        });
    }

    ReadWriteTxContext lockTxForNewUpdates(UUID txId, Map<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> enlistedGroups) {
        return (ReadWriteTxContext)this.txCtxMap.compute(txId, (uuid, tuple0) -> {
            if (tuple0 == null) {
                tuple0 = new ReadWriteTxContext(this.placementDriver, this.clockService);
            }
            assert (!tuple0.isTxFinishing()) : "Transaction is already finished [id=" + String.valueOf(uuid) + "].";
            tuple0.finishTx(enlistedGroups);
            return tuple0;
        });
    }

    static abstract class TxContext {
        volatile long inflights = 0L;

        TxContext() {
        }

        boolean addInflight() {
            if (this.isTxFinishing()) {
                return false;
            }
            ++this.inflights;
            return true;
        }

        void removeInflight(UUID txId) {
            assert (this.inflights > 0L) : IgniteStringFormatter.format((String)"No inflights, cannot remove any [txId={}, ctx={}]", (Object[])new Object[]{txId, this});
            --this.inflights;
        }

        abstract void onInflightsRemoved();

        abstract void finishTx(@Nullable Map<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> var1);

        abstract boolean isTxFinishing();

        abstract boolean isReadyToFinish();
    }

    static class ReadWriteTxContext
    extends TxContext {
        private final CompletableFuture<Void> waitRepFut = new CompletableFuture();
        private final PlacementDriver placementDriver;
        private volatile CompletableFuture<Void> finishInProgressFuture = null;
        private volatile Map<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> enlistedGroups;
        private ClockService clockService;

        private ReadWriteTxContext(PlacementDriver placementDriver, ClockService clockService) {
            this.placementDriver = placementDriver;
            this.clockService = clockService;
        }

        CompletableFuture<Void> performFinish(boolean commit, Function<Boolean, CompletableFuture<Void>> finishAction) {
            this.waitReadyToFinish(commit).whenComplete((ignoredReadyToFinish, readyException) -> ((CompletableFuture)finishAction.apply(commit && readyException == null)).whenComplete((ignoredFinishActionResult, finishException) -> this.completeFinishInProgressFuture(commit, (Throwable)readyException, (Throwable)finishException)));
            return this.finishInProgressFuture;
        }

        private void completeFinishInProgressFuture(boolean commit, @Nullable Throwable readyToFinishException, @Nullable Throwable finishException) {
            if (readyToFinishException == null) {
                if (finishException == null) {
                    this.finishInProgressFuture.complete(null);
                } else {
                    this.finishInProgressFuture.completeExceptionally(finishException);
                }
            } else {
                Throwable unwrappedReadyToFinishException = ExceptionUtils.unwrapCause((Throwable)readyToFinishException);
                if (commit && unwrappedReadyToFinishException instanceof PrimaryReplicaExpiredException) {
                    this.finishInProgressFuture.completeExceptionally((Throwable)((Object)new MismatchingTransactionOutcomeInternalException(ErrorGroups.Transactions.TX_PRIMARY_REPLICA_EXPIRED_ERR, "Failed to commit the transaction.", new TransactionResult(TxState.ABORTED, null), unwrappedReadyToFinishException)));
                } else {
                    this.finishInProgressFuture.completeExceptionally(unwrappedReadyToFinishException);
                }
            }
        }

        private CompletableFuture<Void> waitReadyToFinish(boolean commit) {
            if (commit) {
                HybridTimestamp now = this.clockService.now();
                CompletableFuture[] futures = new CompletableFuture[this.enlistedGroups.size()];
                int cntr = 0;
                for (Map.Entry<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> e : this.enlistedGroups.entrySet()) {
                    futures[cntr++] = this.placementDriver.getPrimaryReplica((ReplicationGroupId)e.getKey(), now).thenApply(replicaMeta -> {
                        Long enlistmentConsistencyToken = (Long)((IgniteBiTuple)e.getValue()).get2();
                        if (replicaMeta == null || !enlistmentConsistencyToken.equals(replicaMeta.getStartTime().longValue())) {
                            return CompletableFuture.failedFuture((Throwable)((Object)new PrimaryReplicaExpiredException((ReplicationGroupId)e.getKey(), enlistmentConsistencyToken, null, (ReplicaMeta)replicaMeta)));
                        }
                        return CompletableFutures.nullCompletedFuture();
                    });
                }
                return CompletableFutures.allOfToList((CompletableFuture[])futures).thenCompose(unused -> this.waitNoInflights());
            }
            return CompletableFutures.nullCompletedFuture();
        }

        private CompletableFuture<Void> waitNoInflights() {
            if (this.inflights == 0L) {
                this.waitRepFut.complete(null);
            }
            return this.waitRepFut;
        }

        void cancelWaitingInflights(TablePartitionId groupId, Long enlistmentConsistencyToken) {
            this.waitRepFut.completeExceptionally((Throwable)((Object)new PrimaryReplicaExpiredException((ReplicationGroupId)groupId, enlistmentConsistencyToken, null, null)));
        }

        @Override
        public void onInflightsRemoved() {
            if (this.inflights == 0L && this.finishInProgressFuture != null) {
                this.waitRepFut.complete(null);
            }
        }

        @Override
        public void finishTx(Map<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> enlistedGroups) {
            this.enlistedGroups = enlistedGroups;
            this.finishInProgressFuture = new CompletableFuture();
        }

        @Override
        public boolean isTxFinishing() {
            return this.finishInProgressFuture != null;
        }

        @Override
        public boolean isReadyToFinish() {
            return this.waitRepFut.isDone();
        }

        public String toString() {
            return "ReadWriteTxContext [inflights=" + this.inflights + ", waitRepFut=" + String.valueOf(this.waitRepFut) + ", finishFut=" + String.valueOf(this.finishInProgressFuture) + "]";
        }
    }

    private static class ReadOnlyTxContext
    extends TxContext {
        private volatile boolean markedFinished;

        private ReadOnlyTxContext() {
        }

        @Override
        public void onInflightsRemoved() {
        }

        @Override
        public void finishTx(@Nullable Map<TablePartitionId, IgniteBiTuple<ClusterNode, Long>> enlistedGroups) {
            this.markedFinished = true;
        }

        @Override
        public boolean isTxFinishing() {
            return this.markedFinished;
        }

        @Override
        public boolean isReadyToFinish() {
            return this.markedFinished && this.inflights == 0L;
        }

        public String toString() {
            return "ReadOnlyTxContext [inflights=" + this.inflights + "]";
        }
    }
}

