/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.rpc.ReadIndexRequestBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

class ReadIndexRequestDeserializer
implements MessageDeserializer<RpcRequests.ReadIndexRequest> {
    private final ReadIndexRequestBuilder msg;

    ReadIndexRequestDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.readIndexRequest();
    }

    public Class<RpcRequests.ReadIndexRequest> klass() {
        return RpcRequests.ReadIndexRequest.class;
    }

    public RpcRequests.ReadIndexRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readList("entriesList", MessageCollectionItemType.BYTE_BUFFER);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.entriesList((List<ByteBuffer>)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readString("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((String)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readString("peerId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.peerId((String)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("serverId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.serverId((String)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RpcRequests.ReadIndexRequest.class);
    }
}

