/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.storage.state.rocksdb;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.configuration.storage.StorageException;
import org.apache.ignite.internal.rocksdb.BusyRocksIteratorAdapter;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.tx.TxMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.storage.state.TxStateStorage;
import org.apache.ignite.internal.tx.storage.state.rocksdb.TxStateRocksDbTableStorage;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.Cursor;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInternalException;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class TxStateRocksDbStorage
implements TxStateStorage {
    private volatile RocksDB db;
    private final WriteOptions writeOptions;
    private final ReadOptions readOptions;
    private final ReadOptions persistedTierReadOptions;
    private final int partitionId;
    private final TxStateRocksDbTableStorage tableStorage;
    private final Set<RocksIterator> iterators = ConcurrentHashMap.newKeySet();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean closeGuard = new AtomicBoolean();
    private volatile long lastAppliedIndex;
    private volatile long persistedIndex;
    private final byte[] lastAppliedIndexKey;

    public TxStateRocksDbStorage(RocksDB db, WriteOptions writeOptions, ReadOptions readOptions, ReadOptions persistedTierReadOptions, int partitionId, TxStateRocksDbTableStorage tableStorage) {
        this.db = db;
        this.writeOptions = writeOptions;
        this.readOptions = readOptions;
        this.persistedTierReadOptions = persistedTierReadOptions;
        this.partitionId = partitionId;
        this.tableStorage = tableStorage;
        this.lastAppliedIndexKey = ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort((short)partitionId).array();
        this.persistedIndex = this.lastAppliedIndex = this.readLastAppliedIndex(readOptions);
    }

    @Override
    public TxMeta get(UUID txId) {
        if (!this.busyLock.enterBusy()) {
            TxStateRocksDbStorage.throwStorageStoppedException();
        }
        try {
            byte[] txMetaBytes = this.db.get(this.txIdToKey(txId));
            TxMeta txMeta = txMetaBytes == null ? null : (TxMeta)ByteUtils.fromBytes((byte[])txMetaBytes);
            return txMeta;
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, "Failed to get a value from the transaction state storage, partition " + this.partitionId + " of table " + ((TableView)this.tableStorage.configuration().value()).name(), (Throwable)e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void put(UUID txId, TxMeta txMeta) {
        if (!this.busyLock.enterBusy()) {
            TxStateRocksDbStorage.throwStorageStoppedException();
        }
        try {
            this.db.put(this.txIdToKey(txId), ByteUtils.toBytes((Object)txMeta));
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, "Failed to put a value into the transaction state storage, partition " + this.partitionId + " of table " + ((TableView)this.tableStorage.configuration().value()).name(), (Throwable)e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public boolean compareAndSet(UUID txId, TxState txStateExpected, TxMeta txMeta, long commandIndex) {
        Objects.requireNonNull(txMeta);
        if (!this.busyLock.enterBusy()) {
            TxStateRocksDbStorage.throwStorageStoppedException();
        }
        byte[] txIdBytes = this.txIdToKey(txId);
        try {
            boolean bl;
            WriteBatch writeBatch = new WriteBatch();
            try {
                boolean result;
                byte[] txMetaExistingBytes = this.db.get(this.readOptions, this.txIdToKey(txId));
                if (txMetaExistingBytes == null && txStateExpected == null) {
                    writeBatch.put(txIdBytes, ByteUtils.toBytes((Object)txMeta));
                    result = true;
                } else if (txMetaExistingBytes != null) {
                    TxMeta txMetaExisting = (TxMeta)ByteUtils.fromBytes((byte[])txMetaExistingBytes);
                    if (txMetaExisting.txState() == txStateExpected) {
                        writeBatch.put(txIdBytes, ByteUtils.toBytes((Object)txMeta));
                        result = true;
                    } else {
                        result = txMetaExisting.txState() == txMeta.txState() && (txMetaExisting.commitTimestamp() == null && txMeta.commitTimestamp() == null || txMetaExisting.commitTimestamp().equals((Object)txMeta.commitTimestamp()));
                    }
                } else {
                    result = false;
                }
                writeBatch.put(this.lastAppliedIndexKey, ByteUtils.longToBytes((long)commandIndex));
                this.db.write(this.writeOptions, writeBatch);
                bl = result;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        writeBatch.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, "Failed perform CAS operation over a value in transaction state storage, partition " + this.partitionId + " of table " + ((TableView)this.tableStorage.configuration().value()).name(), (Throwable)e);
                }
            }
            writeBatch.close();
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void remove(UUID txId) {
        if (!this.busyLock.enterBusy()) {
            TxStateRocksDbStorage.throwStorageStoppedException();
        }
        try {
            this.db.delete(this.txIdToKey(txId));
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, "Failed to remove a value from the transaction state storage, partition " + this.partitionId + " of table " + ((TableView)this.tableStorage.configuration().value()).name(), (Throwable)e);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor<IgniteBiTuple<UUID, TxMeta>> scan() {
        if (!this.busyLock.enterBusy()) {
            TxStateRocksDbStorage.throwStorageStoppedException();
        }
        try {
            byte[] lowerBound = ByteBuffer.allocate(3).putShort((short)this.partitionId).put((byte)0).array();
            byte[] upperBound = this.partitionEndPrefix();
            final RocksIterator rocksIterator = this.db.newIterator(new ReadOptions().setIterateUpperBound((AbstractSlice)new Slice(upperBound)));
            this.iterators.add(rocksIterator);
            try {
                rocksIterator.seek(lowerBound);
            }
            catch (Exception e) {
                this.iterators.remove(rocksIterator);
                rocksIterator.close();
                throw e;
            }
            BusyRocksIteratorAdapter<IgniteBiTuple<UUID, TxMeta>> busyRocksIteratorAdapter = new BusyRocksIteratorAdapter<IgniteBiTuple<UUID, TxMeta>>(this.busyLock, rocksIterator){

                protected IgniteBiTuple<UUID, TxMeta> decodeEntry(byte[] keyBytes, byte[] valueBytes) {
                    UUID key = TxStateRocksDbStorage.this.keyToTxId(keyBytes);
                    TxMeta txMeta = (TxMeta)ByteUtils.fromBytes((byte[])valueBytes);
                    return new IgniteBiTuple((Object)key, (Object)txMeta);
                }

                protected void handleBusy() {
                    TxStateRocksDbStorage.throwStorageStoppedException();
                }

                public void close() throws Exception {
                    TxStateRocksDbStorage.this.iterators.remove(rocksIterator);
                    super.close();
                }
            };
            return busyRocksIteratorAdapter;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public CompletableFuture<Void> flush() {
        return this.tableStorage.awaitFlush(true);
    }

    @Override
    public long lastAppliedIndex() {
        return this.lastAppliedIndex;
    }

    @Override
    public long persistedIndex() {
        return this.persistedIndex;
    }

    void refreshPersistedIndex() {
        if (!this.busyLock.enterBusy()) {
            return;
        }
        try {
            this.persistedIndex = this.readLastAppliedIndex(this.persistedTierReadOptions);
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    private long readLastAppliedIndex(ReadOptions readOptions) {
        byte[] appliedIndexBytes;
        try {
            appliedIndexBytes = this.db.get(readOptions, this.lastAppliedIndexKey);
        }
        catch (RocksDBException e) {
            throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_ERR, "Failed to read applied index value from transaction state storage, partition " + this.partitionId + " of table " + ((TableView)this.tableStorage.configuration().value()).name(), (Throwable)e);
        }
        return appliedIndexBytes == null ? 0L : ByteUtils.bytesToLong((byte[])appliedIndexBytes);
    }

    @Override
    public void destroy() {
        try (WriteBatch writeBatch = new WriteBatch();){
            this.close();
            writeBatch.deleteRange(this.partitionStartPrefix(), this.partitionEndPrefix());
            this.db.write(this.writeOptions, writeBatch);
        }
        catch (Exception e) {
            throw new StorageException("Failed to destroy partition " + this.partitionId + " of table " + this.tableStorage.configuration().name(), (Throwable)e);
        }
    }

    private byte[] partitionStartPrefix() {
        return ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort((short)this.partitionId).array();
    }

    private byte[] partitionEndPrefix() {
        return ByteBuffer.allocate(2).order(ByteOrder.BIG_ENDIAN).putShort((short)(this.partitionId + 1)).array();
    }

    private static void throwStorageStoppedException() {
        throw new IgniteInternalException(ErrorGroups.Transactions.TX_STATE_STORAGE_STOPPED_ERR, "Transaction state storage is stopped");
    }

    private byte[] txIdToKey(UUID txId) {
        return ByteBuffer.allocate(18).order(ByteOrder.BIG_ENDIAN).putShort((short)this.partitionId).putLong(txId.getMostSignificantBits()).putLong(txId.getLeastSignificantBits()).array();
    }

    private UUID keyToTxId(byte[] bytes) {
        long msb = ByteUtils.bytesToLong((byte[])bytes, (int)2);
        long lsb = ByteUtils.bytesToLong((byte[])bytes, (int)10);
        return new UUID(msb, lsb);
    }

    @Override
    public void close() throws Exception {
        if (!this.closeGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        ArrayList<RocksIterator> resources = new ArrayList<RocksIterator>(this.iterators);
        IgniteUtils.closeAll(resources);
    }
}

