/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.raft.snapshot;

import java.util.List;
import org.apache.ignite.internal.raft.storage.SnapshotStorageFactory;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionAccess;
import org.apache.ignite.internal.table.distributed.raft.snapshot.PartitionSnapshotStorage;
import org.apache.ignite.internal.table.distributed.raft.snapshot.outgoing.OutgoingSnapshotsManager;
import org.apache.ignite.network.TopologyService;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.RaftOutter;
import org.apache.ignite.raft.jraft.option.RaftOptions;
import org.apache.ignite.raft.jraft.storage.SnapshotStorage;

public class PartitionSnapshotStorageFactory
implements SnapshotStorageFactory {
    private final TopologyService topologyService;
    private final OutgoingSnapshotsManager outgoingSnapshotsManager;
    private final PartitionAccess partition;
    private final List<String> peers;
    private final List<String> learners;
    private final long persistedRaftIndex;

    public PartitionSnapshotStorageFactory(TopologyService topologyService, OutgoingSnapshotsManager outgoingSnapshotsManager, PartitionAccess partition, List<String> peers, List<String> learners) {
        this.topologyService = topologyService;
        this.outgoingSnapshotsManager = outgoingSnapshotsManager;
        this.partition = partition;
        this.peers = peers;
        this.learners = learners;
        this.persistedRaftIndex = partition.persistedIndex();
    }

    public SnapshotStorage createSnapshotStorage(String uri, RaftOptions raftOptions) {
        RaftOutter.SnapshotMeta snapshotMeta = new RaftMessagesFactory().snapshotMeta().lastIncludedIndex(this.persistedRaftIndex).lastIncludedTerm(this.persistedRaftIndex > 0L ? 1L : 0L).peersList(this.peers).learnersList(this.learners).build();
        return new PartitionSnapshotStorage(this.topologyService, this.outgoingSnapshotsManager, uri, raftOptions, this.partition, snapshotMeta);
    }
}

