/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.netty;

import io.netty.bootstrap.Bootstrap;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.ignite.configuration.schemas.network.NetworkView;
import org.apache.ignite.internal.future.OrderingFuture;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.NetworkMessagesFactory;
import org.apache.ignite.internal.network.handshake.HandshakeManager;
import org.apache.ignite.internal.network.netty.DefaultRecoveryDescriptorProvider;
import org.apache.ignite.internal.network.netty.InNetworkObject;
import org.apache.ignite.internal.network.netty.NettyClient;
import org.apache.ignite.internal.network.netty.NettySender;
import org.apache.ignite.internal.network.netty.NettyServer;
import org.apache.ignite.internal.network.recovery.RecoveryClientHandhakeManagerFactory;
import org.apache.ignite.internal.network.recovery.RecoveryClientHandshakeManager;
import org.apache.ignite.internal.network.recovery.RecoveryDescriptorProvider;
import org.apache.ignite.internal.network.recovery.RecoveryServerHandshakeManager;
import org.apache.ignite.internal.network.serialization.SerializationService;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.network.NettyBootstrapFactory;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ConnectionManager {
    private static final NetworkMessagesFactory FACTORY = new NetworkMessagesFactory();
    private static final IgniteLogger LOG = Loggers.forClass(ConnectionManager.class);
    public static final byte DIRECT_PROTOCOL_VERSION = 1;
    private final Bootstrap clientBootstrap;
    private final NettyServer server;
    private final Map<String, NettySender> channels = new ConcurrentHashMap<String, NettySender>();
    private final Map<SocketAddress, NettyClient> clients = new ConcurrentHashMap<SocketAddress, NettyClient>();
    private final SerializationService serializationService;
    private final List<Consumer<InNetworkObject>> listeners = new CopyOnWriteArrayList<Consumer<InNetworkObject>>();
    private final String consistentId;
    private final UUID launchId;
    private final RecoveryClientHandhakeManagerFactory clientHandhakeManagerFactory;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final RecoveryDescriptorProvider descriptorProvider = new DefaultRecoveryDescriptorProvider();

    public ConnectionManager(NetworkView networkConfiguration, SerializationService serializationService, UUID launchId, String consistentId, NettyBootstrapFactory bootstrapFactory) {
        this(networkConfiguration, serializationService, launchId, consistentId, bootstrapFactory, new DefaultRecoveryClientHandhakeManagerFactory());
    }

    public ConnectionManager(NetworkView networkConfiguration, SerializationService serializationService, UUID launchId, String consistentId, NettyBootstrapFactory bootstrapFactory, RecoveryClientHandhakeManagerFactory clientHandhakeManagerFactory) {
        this.serializationService = serializationService;
        this.launchId = launchId;
        this.consistentId = consistentId;
        this.clientHandhakeManagerFactory = clientHandhakeManagerFactory;
        this.server = new NettyServer(networkConfiguration, this::createServerHandshakeManager, this::onNewIncomingChannel, this::onMessage, serializationService, bootstrapFactory);
        this.clientBootstrap = bootstrapFactory.createClientBootstrap();
    }

    public void start() throws IgniteInternalException {
        try {
            boolean wasStarted = this.started.getAndSet(true);
            if (wasStarted) {
                throw new IgniteInternalException("Attempted to start an already started connection manager");
            }
            if (this.stopped.get()) {
                throw new IgniteInternalException("Attempted to start an already stopped connection manager");
            }
            this.server.start().get();
            LOG.info("Server started [address={}]", new Object[]{this.server.address()});
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new IgniteInternalException("Failed to start the connection manager: " + cause.getMessage(), cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteInternalException("Interrupted while starting the connection manager", (Throwable)e);
        }
    }

    public SocketAddress getLocalAddress() {
        return this.server.address();
    }

    public OrderingFuture<NettySender> channel(@Nullable String consistentId, SocketAddress address) {
        NettySender channel;
        if (consistentId != null && (channel = this.channels.compute(consistentId, (addr, sender) -> sender == null || !sender.isOpen() ? null : sender)) != null) {
            return OrderingFuture.completedFuture((Object)channel);
        }
        NettyClient client = this.clients.compute(address, (addr, existingClient) -> existingClient != null && !existingClient.failedToConnect() && !existingClient.isDisconnected() ? existingClient : this.connect((SocketAddress)addr, (short)0));
        return client.sender();
    }

    private void onMessage(InNetworkObject message) {
        this.listeners.forEach(consumer -> consumer.accept(message));
    }

    private void onNewIncomingChannel(NettySender channel) {
        NettySender oldChannel = this.channels.put(channel.consistentId(), channel);
        if (oldChannel != null) {
            oldChannel.close();
        }
    }

    private NettyClient connect(SocketAddress address, short connectionId) {
        NettyClient client = new NettyClient(address, this.serializationService, this.createClientHandshakeManager(connectionId), this::onMessage);
        client.start(this.clientBootstrap).whenComplete((sender, throwable) -> {
            if (throwable == null) {
                this.channels.put(sender.consistentId(), (NettySender)sender);
            } else {
                this.clients.remove(address);
            }
        });
        return client;
    }

    public void addListener(Consumer<InNetworkObject> listener) {
        this.listeners.add(listener);
    }

    public void stop() {
        boolean wasStopped = this.stopped.getAndSet(true);
        if (wasStopped) {
            return;
        }
        Stream<CompletableFuture> stream = Stream.concat(Stream.concat(this.clients.values().stream().map(NettyClient::stop), Stream.of(this.server.stop())), this.channels.values().stream().map(NettySender::closeAsync));
        CompletableFuture<Void> stopFut = CompletableFuture.allOf((CompletableFuture[])stream.toArray(CompletableFuture[]::new));
        try {
            stopFut.join();
        }
        catch (Exception e) {
            LOG.warn("Failed to stop connection manager [reason={}]", new Object[]{e.getMessage()});
        }
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    private HandshakeManager createClientHandshakeManager(short connectionId) {
        return this.clientHandhakeManagerFactory.create(this.launchId, this.consistentId, connectionId, this.descriptorProvider);
    }

    private HandshakeManager createServerHandshakeManager() {
        return new RecoveryServerHandshakeManager(this.launchId, this.consistentId, FACTORY, this.descriptorProvider);
    }

    @TestOnly
    public NettyServer server() {
        return this.server;
    }

    public String consistentId() {
        return this.consistentId;
    }

    @TestOnly
    public Collection<NettyClient> clients() {
        return Collections.unmodifiableCollection(this.clients.values());
    }

    @TestOnly
    public Map<String, NettySender> channels() {
        return Collections.unmodifiableMap(this.channels);
    }

    private static class DefaultRecoveryClientHandhakeManagerFactory
    implements RecoveryClientHandhakeManagerFactory {
        private DefaultRecoveryClientHandhakeManagerFactory() {
        }

        @Override
        public RecoveryClientHandshakeManager create(UUID launchId, String consistentId, short connectionId, RecoveryDescriptorProvider recoveryDescriptorProvider) {
            return new RecoveryClientHandshakeManager(launchId, consistentId, connectionId, recoveryDescriptorProvider);
        }
    }
}

