/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.exception;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.internal.cli.core.exception.ExceptionHandler;
import org.apache.ignite.internal.cli.core.exception.ExceptionWriter;
import org.apache.ignite.internal.cli.core.exception.WrappedException;

public class ExceptionHandlers {
    private final Map<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>> map = new HashMap<Class<? extends Throwable>, ExceptionHandler<? extends Throwable>>();
    private final ExceptionHandler<Throwable> defaultHandler;

    public ExceptionHandlers() {
        this(ExceptionHandler.DEFAULT);
    }

    public ExceptionHandlers(ExceptionHandler<Throwable> defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public <T extends Throwable> void addExceptionHandler(ExceptionHandler<T> exceptionHandler) {
        this.map.put(exceptionHandler.applicableException(), exceptionHandler);
    }

    public void addExceptionHandlers(ExceptionHandlers exceptionHandlers) {
        this.map.putAll(exceptionHandlers.map);
    }

    public <T extends Throwable> int handleException(ExceptionWriter errOutput, T e) {
        return this.processException(errOutput, e instanceof WrappedException ? e.getCause() : e);
    }

    public <T extends Throwable> int handleException(T e) {
        return this.processException(ExceptionWriter.nullWriter(), e instanceof WrappedException ? e.getCause() : e);
    }

    private <T extends Throwable> int processException(ExceptionWriter errOutput, T e) {
        ExceptionHandler<? extends Throwable> exceptionHandler = this.map.get(e.getClass());
        if (exceptionHandler != null) {
            return exceptionHandler.handle(errOutput, e);
        }
        return this.defaultHandler.handle(errOutput, e);
    }
}

