/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.ignite.internal.sql.engine.sql.IgniteSqlIndexType;

public class IgniteSqlCreateIndex
extends SqlCreate {
    private final SqlIdentifier idxName;
    private final SqlIdentifier tblName;
    private final IgniteSqlIndexType type;
    private final SqlNodeList columnList;
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("CREATE INDEX", SqlKind.CREATE_INDEX);

    public IgniteSqlCreateIndex(SqlParserPos pos, boolean ifNotExists, SqlIdentifier idxName, SqlIdentifier tblName, IgniteSqlIndexType type, SqlNodeList columnList) {
        super(OPERATOR, pos, false, ifNotExists);
        this.idxName = Objects.requireNonNull(idxName, "index name");
        this.tblName = Objects.requireNonNull(tblName, "table name");
        this.type = Objects.requireNonNull(type, "type");
        this.columnList = columnList;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.idxName, (Object)this.tblName, (Object)this.columnList);
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        writer.keyword("INDEX");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.idxName.unparse(writer, 0, 0);
        writer.keyword("ON");
        this.tblName.unparse(writer, 0, 0);
        if (this.type != IgniteSqlIndexType.IMPLICIT_TREE) {
            writer.keyword("USING");
            writer.keyword(this.type.name());
        }
        SqlWriter.Frame frame = writer.startList("(", ")");
        for (SqlNode c : this.columnList) {
            writer.sep(",");
            boolean desc = false;
            if (c.getKind() == SqlKind.DESCENDING) {
                c = (SqlNode)((SqlCall)c).getOperandList().get(0);
                desc = true;
            }
            c.unparse(writer, 0, 0);
            if (!desc) continue;
            writer.keyword("DESC");
        }
        writer.endList(frame);
    }

    public SqlIdentifier indexName() {
        return this.idxName;
    }

    public SqlIdentifier tableName() {
        return this.tblName;
    }

    public IgniteSqlIndexType type() {
        return this.type;
    }

    public SqlNodeList columnList() {
        return this.columnList;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }
}

