/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.redis.string;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestProtocolHandler;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.redis.GridRedisRestCommandHandler;
import org.apache.ignite.internal.processors.rest.handlers.redis.exception.GridRedisGenericException;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisCommand;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisMessage;
import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.GridRedisProtocolParser;
import org.apache.ignite.internal.processors.rest.request.GridRestCacheRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridRedisGetRangeCommandHandler
extends GridRedisRestCommandHandler {
    private static final Collection<GridRedisCommand> SUPPORTED_COMMANDS = U.sealList(GridRedisCommand.GETRANGE);
    private static final int START_OFFSET_POS = 1;
    private static final int END_OFFSET_POS = 2;

    public GridRedisGetRangeCommandHandler(IgniteLogger log, GridRestProtocolHandler hnd, GridKernalContext ctx) {
        super(log, hnd, ctx);
    }

    @Override
    public Collection<GridRedisCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public GridRestRequest asRestRequest(GridRedisMessage msg) throws IgniteCheckedException {
        assert (msg != null);
        if (msg.messageSize() < 4) {
            throw new GridRedisGenericException("Wrong number of arguments");
        }
        GridRestCacheRequest getReq = new GridRestCacheRequest();
        getReq.clientId(msg.clientId());
        getReq.key(msg.key());
        getReq.command(GridRestCommand.CACHE_GET);
        getReq.cacheName(msg.cacheName());
        return getReq;
    }

    @Override
    public ByteBuffer makeResponse(GridRestResponse restRes, List<String> params) {
        if (restRes.getResponse() == null) {
            return GridRedisProtocolParser.toBulkString("");
        }
        if (restRes.getResponse() instanceof String) {
            int endOff;
            int startOff;
            String res = String.valueOf(restRes.getResponse());
            try {
                startOff = this.boundedStartOffset(Integer.parseInt(params.get(1)), res.length());
                endOff = this.boundedEndOffset(Integer.parseInt(params.get(2)), res.length());
            }
            catch (NumberFormatException e) {
                U.error(this.log, "Erroneous offset", e);
                return GridRedisProtocolParser.toGenericError("Offset is not an integer");
            }
            return GridRedisProtocolParser.toBulkString(res.substring(startOff, endOff));
        }
        return GridRedisProtocolParser.toTypeError("Operation against a key holding the wrong kind of value");
    }

    private int boundedStartOffset(int idx, int size) {
        return idx >= 0 ? Math.min(idx, size) : size + idx;
    }

    private int boundedEndOffset(int idx, int size) {
        return idx >= 0 ? Math.min(idx + 1, size) : size + idx + 1;
    }
}

