/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.failover;

import java.util.Map;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;
import org.apache.ignite.cache.CacheEntryProcessor;
import org.apache.ignite.yardstick.cache.failover.IgniteFailoverAbstractBenchmark;

public class IgniteAtomicRetriesBenchmark
extends IgniteFailoverAbstractBenchmark<Integer, String> {
    public boolean test(Map<Object, Object> ctx) throws Exception {
        int key = IgniteAtomicRetriesBenchmark.nextRandom(this.args.range());
        int opNum = IgniteAtomicRetriesBenchmark.nextRandom(4);
        int timeout = this.args.cacheOperationTimeoutMillis();
        switch (opNum) {
            case 0: {
                this.cache.getAsync((Object)key).get((long)timeout);
                break;
            }
            case 1: {
                this.cache.putAsync((Object)key, (Object)String.valueOf(key)).get((long)timeout);
                break;
            }
            case 2: {
                this.cache.invokeAsync((Object)key, (CacheEntryProcessor)new TestCacheEntryProcessor(), new Object[0]).get((long)timeout);
                break;
            }
            case 3: {
                this.cache.removeAsync((Object)key).get((long)timeout);
                break;
            }
            default: {
                throw new IllegalStateException("Got invalid operation number: " + opNum);
            }
        }
        return true;
    }

    @Override
    protected String cacheName() {
        return "atomic-reties";
    }

    private static class TestCacheEntryProcessor
    implements CacheEntryProcessor<Integer, String, String> {
        private static final long serialVersionUID = 0L;

        private TestCacheEntryProcessor() {
        }

        public String process(MutableEntry<Integer, String> entry, Object ... arguments) throws EntryProcessorException {
            return "key";
        }
    }
}

