/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.healthcare.v1.CloudHealthcare;
import com.google.api.services.healthcare.v1.CloudHealthcareRequest;
import com.google.api.services.healthcare.v1.model.CreateMessageRequest;
import com.google.api.services.healthcare.v1.model.DeidentifyConfig;
import com.google.api.services.healthcare.v1.model.DeidentifyFhirStoreRequest;
import com.google.api.services.healthcare.v1.model.DicomStore;
import com.google.api.services.healthcare.v1.model.Empty;
import com.google.api.services.healthcare.v1.model.ExportResourcesRequest;
import com.google.api.services.healthcare.v1.model.FhirStore;
import com.google.api.services.healthcare.v1.model.GoogleCloudHealthcareV1FhirBigQueryDestination;
import com.google.api.services.healthcare.v1.model.GoogleCloudHealthcareV1FhirGcsDestination;
import com.google.api.services.healthcare.v1.model.GoogleCloudHealthcareV1FhirGcsSource;
import com.google.api.services.healthcare.v1.model.Hl7V2Store;
import com.google.api.services.healthcare.v1.model.HttpBody;
import com.google.api.services.healthcare.v1.model.ImportResourcesRequest;
import com.google.api.services.healthcare.v1.model.IngestMessageRequest;
import com.google.api.services.healthcare.v1.model.IngestMessageResponse;
import com.google.api.services.healthcare.v1.model.ListFhirStoresResponse;
import com.google.api.services.healthcare.v1.model.ListMessagesResponse;
import com.google.api.services.healthcare.v1.model.Message;
import com.google.api.services.healthcare.v1.model.NotificationConfig;
import com.google.api.services.healthcare.v1.model.Operation;
import com.google.api.services.healthcare.v1.model.SchemaConfig;
import com.google.api.services.healthcare.v1.model.SearchResourcesRequest;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.WebPathParser;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHealthcareApiClient
implements HealthcareApiClient,
Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized String USER_AGENT = String.format("apache-beam-io-google-cloud-platform-healthcare/%s", ReleaseInfo.getReleaseInfo().getSdkVersion());
    private static final @UnknownKeyFor @NonNull @Initialized JsonFactory PARSER = new GsonFactory();
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(HttpHealthcareApiClient.class);
    private transient @UnknownKeyFor @NonNull @Initialized CloudHealthcare client;
    private transient @UnknownKeyFor @NonNull @Initialized HttpClient httpClient;
    private transient @UnknownKeyFor @NonNull @Initialized GoogleCredentials credentials;

    public HttpHealthcareApiClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.initClient();
    }

    public HttpHealthcareApiClient(@UnknownKeyFor @NonNull @Initialized CloudHealthcare client) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.client = client;
        this.httpClient = HttpClients.createDefault();
        this.initClient();
    }

    public @UnknownKeyFor @NonNull @Initialized JsonFactory getJsonFactory() {
        return this.client.getJsonFactory();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Hl7V2Store createHL7v2Store(@UnknownKeyFor @NonNull @Initialized String dataset, @UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Hl7V2Store store = new Hl7V2Store();
        return (Hl7V2Store)this.client.projects().locations().datasets().hl7V2Stores().create(dataset, store).setHl7V2StoreId(name).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FhirStore createFhirStore(@UnknownKeyFor @NonNull @Initialized String dataset, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String version) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.createFhirStore(dataset, name, version, null);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized FhirStore createFhirStore(@UnknownKeyFor @NonNull @Initialized String dataset, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized String version, @Nullable @UnknownKeyFor @Initialized String pubsubTopic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        FhirStore store = new FhirStore();
        store.setVersion(version);
        store.setDisableReferentialIntegrity(Boolean.valueOf(true));
        store.setEnableUpdateCreate(Boolean.valueOf(true));
        if (pubsubTopic != null) {
            NotificationConfig notificationConfig = new NotificationConfig();
            notificationConfig.setPubsubTopic(pubsubTopic);
            store.setNotificationConfig(notificationConfig);
        }
        return (FhirStore)this.client.projects().locations().datasets().fhirStores().create(dataset, store).setFhirStoreId(name).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FhirStore> listAllFhirStores(@UnknownKeyFor @NonNull @Initialized String dataset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ListFhirStoresResponse resp;
        ArrayList<FhirStore> fhirStores = new ArrayList<FhirStore>();
        String pageToken = "";
        do {
            resp = (ListFhirStoresResponse)this.client.projects().locations().datasets().fhirStores().list(dataset).setPageToken(pageToken).execute();
            for (FhirStore fs : resp.getFhirStores()) {
                fhirStores.add(fs);
            }
        } while (resp.getNextPageToken() != null && !(pageToken = resp.getNextPageToken()).equals(""));
        return fhirStores;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Empty deleteHL7v2Store(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (Empty)this.client.projects().locations().datasets().hl7V2Stores().delete(name).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Empty deleteFhirStore(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (Empty)this.client.projects().locations().datasets().fhirStores().delete(name).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String retrieveDicomStudyMetadata(@UnknownKeyFor @NonNull @Initialized String dicomWebPath) throws @UnknownKeyFor @NonNull @Initialized IOException {
        WebPathParser parser = new WebPathParser();
        WebPathParser.DicomWebPath parsedDicomWebPath = parser.parseDicomWebpath(dicomWebPath);
        String searchQuery = String.format("studies/%s/metadata", parsedDicomWebPath.studyId);
        return this.makeRetrieveStudyMetadataRequest(parsedDicomWebPath.dicomStorePath, searchQuery);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DicomStore createDicomStore(@UnknownKeyFor @NonNull @Initialized String dataset, @UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.createDicomStore(dataset, name, null);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Empty deleteDicomStore(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (Empty)this.client.projects().locations().datasets().dicomStores().delete(name).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Empty uploadToDicomStore(@UnknownKeyFor @NonNull @Initialized String webPath, @UnknownKeyFor @NonNull @Initialized String filePath) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized URISyntaxException {
        byte[] dcmFile = Files.readAllBytes(Paths.get(filePath, new String[0]));
        ByteArrayEntity requestEntity = new ByteArrayEntity(dcmFile);
        String uri = String.format("%sv1/%s/dicomWeb/studies", this.client.getRootUrl(), webPath);
        URIBuilder uriBuilder = new URIBuilder(uri).setParameter("access_token", this.credentials.getAccessToken().getTokenValue());
        HttpUriRequest request = RequestBuilder.post((URI)uriBuilder.build()).setEntity((HttpEntity)requestEntity).addHeader("Content-Type", "application/dicom").build();
        this.httpClient.execute(request);
        return new Empty();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DicomStore createDicomStore(@UnknownKeyFor @NonNull @Initialized String dataset, @UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized String pubsubTopic) throws @UnknownKeyFor @NonNull @Initialized IOException {
        DicomStore store = new DicomStore();
        if (pubsubTopic != null) {
            NotificationConfig notificationConfig = new NotificationConfig();
            notificationConfig.setPubsubTopic(pubsubTopic);
            store.setNotificationConfig(notificationConfig);
        }
        return (DicomStore)this.client.projects().locations().datasets().dicomStores().create(dataset, store).setDicomStoreId(name).execute();
    }

    private @UnknownKeyFor @NonNull @Initialized String makeRetrieveStudyMetadataRequest(@UnknownKeyFor @NonNull @Initialized String dicomStorePath, @UnknownKeyFor @NonNull @Initialized String searchQuery) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CloudHealthcare.Projects.Locations.Datasets.DicomStores.Studies.RetrieveMetadata request = this.client.projects().locations().datasets().dicomStores().studies().retrieveMetadata(dicomStorePath, searchQuery);
        HttpResponse response = request.executeUnparsed();
        return response.parseAsString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant getEarliestHL7v2SendTime(@UnknownKeyFor @NonNull @Initialized String hl7v2Store, @Nullable @UnknownKeyFor @Initialized String filter) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ListMessagesResponse response = (ListMessagesResponse)this.client.projects().locations().datasets().hl7V2Stores().messages().list(hl7v2Store).setFilter(filter).set("view", (Object)"full").setOrderBy("sendTime").setPageSize(Integer.valueOf(1)).execute();
        if (response.isEmpty()) {
            throw new IllegalArgumentException(String.format("Could not find earliest send time. The filter %s  matched no results on HL7v2 Store: %s", filter, hl7v2Store));
        }
        String sendTime = ((Message)response.getHl7V2Messages().get(0)).getSendTime();
        if (Strings.isNullOrEmpty((String)sendTime)) {
            LOG.warn(String.format("Earliest message in %s has null or empty sendTime defaulting to Epoch.", hl7v2Store));
            return Instant.ofEpochMilli((long)0L);
        }
        return Instant.parse((String)sendTime);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Instant getLatestHL7v2SendTime(@UnknownKeyFor @NonNull @Initialized String hl7v2Store, @Nullable @UnknownKeyFor @Initialized String filter) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ListMessagesResponse response = (ListMessagesResponse)this.client.projects().locations().datasets().hl7V2Stores().messages().list(hl7v2Store).setFilter(filter).set("view", (Object)"full").setOrderBy("sendTime desc").setPageSize(Integer.valueOf(1)).execute();
        if (response.isEmpty()) {
            throw new IllegalArgumentException(String.format("Could not find latest send time. The filter %s  matched no results on HL7v2 Store: %s", filter, hl7v2Store));
        }
        String sendTime = ((Message)response.getHl7V2Messages().get(0)).getSendTime();
        if (Strings.isNullOrEmpty((String)sendTime)) {
            LOG.warn(String.format("Latest message in %s has null or empty sendTime defaulting to now.", hl7v2Store));
            return Instant.now();
        }
        return Instant.parse((String)sendTime);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ListMessagesResponse makeSendTimeBoundHL7v2ListRequest(@UnknownKeyFor @NonNull @Initialized String hl7v2Store, @UnknownKeyFor @NonNull @Initialized Instant start, @Nullable @UnknownKeyFor @Initialized Instant end, @Nullable @UnknownKeyFor @Initialized String otherFilter, @Nullable @UnknownKeyFor @Initialized String orderBy, @Nullable @UnknownKeyFor @Initialized String pageToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String sendTimeFilter = "";
        if (start != null) {
            sendTimeFilter = sendTimeFilter + String.format("sendTime >= \"%s\"", start.toString());
            if (end != null) {
                sendTimeFilter = sendTimeFilter + String.format(" AND sendTime < \"%s\"", end.toString());
            }
        }
        String filter = otherFilter != null && !Strings.isNullOrEmpty((String)sendTimeFilter) ? sendTimeFilter + " AND " + otherFilter : sendTimeFilter;
        return this.makeHL7v2ListRequest(hl7v2Store, filter, orderBy, pageToken);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ListMessagesResponse makeHL7v2ListRequest(@UnknownKeyFor @NonNull @Initialized String hl7v2Store, @Nullable @UnknownKeyFor @Initialized String filter, @Nullable @UnknownKeyFor @Initialized String orderBy, @Nullable @UnknownKeyFor @Initialized String pageToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CloudHealthcare.Projects.Locations.Datasets.Hl7V2Stores.Messages.List baseRequest = this.client.projects().locations().datasets().hl7V2Stores().messages().list(hl7v2Store).set("view", (Object)"full").setFilter(filter).setPageSize(Integer.valueOf(1000)).setPageToken(pageToken);
        if (orderBy == null) {
            return (ListMessagesResponse)baseRequest.execute();
        }
        return (ListMessagesResponse)baseRequest.setOrderBy(orderBy).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Message getHL7v2Message(@UnknownKeyFor @NonNull @Initialized String msgName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Message msg = (Message)this.client.projects().locations().datasets().hl7V2Stores().messages().get(msgName).execute();
        if (msg == null) {
            throw new IOException(String.format("Couldn't find message: %s.", msgName));
        }
        return msg;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Empty deleteHL7v2Message(@UnknownKeyFor @NonNull @Initialized String msgName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (Empty)this.client.projects().locations().datasets().hl7V2Stores().messages().delete(msgName).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Hl7V2Store getHL7v2Store(@UnknownKeyFor @NonNull @Initialized String storeName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (Hl7V2Store)this.client.projects().locations().datasets().hl7V2Stores().get(storeName).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized IngestMessageResponse ingestHL7v2Message(@UnknownKeyFor @NonNull @Initialized String hl7v2Store, @UnknownKeyFor @NonNull @Initialized Message msg) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IngestMessageRequest ingestMessageRequest = new IngestMessageRequest();
        ingestMessageRequest.setMessage(msg);
        return (IngestMessageResponse)this.client.projects().locations().datasets().hl7V2Stores().messages().ingest(hl7v2Store, ingestMessageRequest).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Message createHL7v2Message(@UnknownKeyFor @NonNull @Initialized String hl7v2Store, @UnknownKeyFor @NonNull @Initialized Message msg) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CreateMessageRequest createMessageRequest = new CreateMessageRequest();
        createMessageRequest.setMessage(msg);
        return (Message)this.client.projects().locations().datasets().hl7V2Stores().messages().create(hl7v2Store, createMessageRequest).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Operation importFhirResource(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String gcsSourcePath, @Nullable @UnknownKeyFor @Initialized String contentStructure) throws @UnknownKeyFor @NonNull @Initialized IOException {
        GoogleCloudHealthcareV1FhirGcsSource gcsSrc = new GoogleCloudHealthcareV1FhirGcsSource();
        gcsSrc.setUri(gcsSourcePath);
        ImportResourcesRequest importRequest = new ImportResourcesRequest();
        importRequest.setGcsSource(gcsSrc).setContentStructure(contentStructure);
        return (Operation)this.client.projects().locations().datasets().fhirStores().healthcareImport(fhirStore, importRequest).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Operation exportFhirResourceToGcs(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String gcsDestinationPrefix) throws @UnknownKeyFor @NonNull @Initialized IOException {
        GoogleCloudHealthcareV1FhirGcsDestination gcsDst = new GoogleCloudHealthcareV1FhirGcsDestination();
        gcsDst.setUriPrefix(gcsDestinationPrefix);
        ExportResourcesRequest exportRequest = new ExportResourcesRequest();
        exportRequest.setGcsDestination(gcsDst);
        return (Operation)this.client.projects().locations().datasets().fhirStores().export(fhirStore, exportRequest).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Operation exportFhirResourceToBigQuery(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String bigQueryDatasetUri) throws @UnknownKeyFor @NonNull @Initialized IOException {
        GoogleCloudHealthcareV1FhirBigQueryDestination bigQueryDestination = new GoogleCloudHealthcareV1FhirBigQueryDestination();
        bigQueryDestination.setDatasetUri(bigQueryDatasetUri);
        SchemaConfig schemaConfig = new SchemaConfig();
        schemaConfig.setSchemaType("ANALYTICS");
        bigQueryDestination.setSchemaConfig(schemaConfig);
        ExportResourcesRequest exportRequest = new ExportResourcesRequest();
        exportRequest.setBigqueryDestination(bigQueryDestination);
        return (Operation)this.client.projects().locations().datasets().fhirStores().export(fhirStore, exportRequest).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Operation deidentifyFhirStore(@UnknownKeyFor @NonNull @Initialized String sourcefhirStore, @UnknownKeyFor @NonNull @Initialized String destinationFhirStore, @UnknownKeyFor @NonNull @Initialized DeidentifyConfig deidConfig) throws @UnknownKeyFor @NonNull @Initialized IOException {
        DeidentifyFhirStoreRequest deidRequest = new DeidentifyFhirStoreRequest();
        deidRequest.setDestinationStore(destinationFhirStore);
        deidRequest.setConfig(deidConfig);
        return (Operation)this.client.projects().locations().datasets().fhirStores().deidentify(sourcefhirStore, deidRequest).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Operation pollOperation(@UnknownKeyFor @NonNull @Initialized Operation operation, @UnknownKeyFor @NonNull @Initialized Long sleepMs) throws @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.debug(String.format("Operation %s started, polling until complete.", operation.getName()));
        while (operation.getDone() == null || !operation.getDone().booleanValue()) {
            Thread.sleep(sleepMs);
            operation = (Operation)this.client.projects().locations().datasets().operations().get(operation.getName()).execute();
        }
        return operation;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized HttpBody executeFhirBundle(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String bundle) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.client == null) {
            this.initClient();
        }
        HttpBody httpBody = (HttpBody)PARSER.fromString(bundle, HttpBody.class);
        return (HttpBody)this.client.projects().locations().datasets().fhirStores().fhir().executeBundle(fhirStore, httpBody).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized HttpBody readFhirResource(@UnknownKeyFor @NonNull @Initialized String resourceName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (HttpBody)this.client.projects().locations().datasets().fhirStores().fhir().read(resourceName).execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized HttpBody searchFhirResource(@UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String resourceType, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parameters, @UnknownKeyFor @NonNull @Initialized String pageToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Object search = Strings.isNullOrEmpty((String)resourceType) ? this.client.projects().locations().datasets().fhirStores().fhir().search(fhirStore, new SearchResourcesRequest()) : this.client.projects().locations().datasets().fhirStores().fhir().searchType(fhirStore, resourceType, new SearchResourcesRequest());
        if (parameters != null && !parameters.isEmpty()) {
            parameters.forEach((arg_0, arg_1) -> ((CloudHealthcareRequest)search).set(arg_0, arg_1));
        }
        if (pageToken != null && !pageToken.isEmpty()) {
            search.set("_page_token", (Object)URLDecoder.decode(pageToken, "UTF-8"));
        }
        return (HttpBody)search.execute();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized HttpBody getPatientEverything(@UnknownKeyFor @NonNull @Initialized String resourceName, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> filters, @UnknownKeyFor @NonNull @Initialized String pageToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CloudHealthcare.Projects.Locations.Datasets.FhirStores.Fhir.PatientEverything patientEverything = this.client.projects().locations().datasets().fhirStores().fhir().patientEverything(resourceName);
        if (filters != null && !filters.isEmpty()) {
            filters.forEach((arg_0, arg_1) -> ((CloudHealthcare.Projects.Locations.Datasets.FhirStores.Fhir.PatientEverything)patientEverything).set(arg_0, arg_1));
        }
        if (pageToken != null && !pageToken.isEmpty()) {
            patientEverything.set("_page_token", (Object)URLDecoder.decode(pageToken, "UTF-8"));
        }
        return (HttpBody)patientEverything.execute();
    }

    private void initClient() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.credentials = GoogleCredentials.getApplicationDefault();
        AuthenticatedRetryInitializer requestInitializer = new AuthenticatedRetryInitializer(this.credentials.createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/cloud-platform.read-only"}));
        this.client = new CloudHealthcare.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new GsonFactory(), (HttpRequestInitializer)requestInitializer).setApplicationName("apache-beam-hl7v2-io").build();
        this.httpClient = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(10, false)).build();
    }

    public static class FhirResourcePagesIterator
    implements Iterator<JsonArray> {
        private final @UnknownKeyFor @NonNull @Initialized FhirMethod fhirMethod;
        private final @UnknownKeyFor @NonNull @Initialized String fhirStore;
        private final @UnknownKeyFor @NonNull @Initialized String resourceType;
        private final @UnknownKeyFor @NonNull @Initialized String resourceName;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parameters;
        private final @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
        private final @UnknownKeyFor @NonNull @Initialized ObjectMapper mapper;
        private @UnknownKeyFor @NonNull @Initialized String pageToken;
        private @UnknownKeyFor @NonNull @Initialized boolean isFirstRequest;

        public FhirResourcePagesIterator(@UnknownKeyFor @NonNull @Initialized FhirMethod fhirMethod, @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String resourceType, @UnknownKeyFor @NonNull @Initialized String resourceName, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parameters) {
            this.fhirMethod = fhirMethod;
            this.client = client;
            this.fhirStore = fhirStore;
            this.resourceType = resourceType;
            this.resourceName = resourceName;
            this.parameters = parameters;
            this.pageToken = null;
            this.isFirstRequest = true;
            this.mapper = new ObjectMapper();
        }

        public static @UnknownKeyFor @NonNull @Initialized FhirResourcePagesIterator ofSearch(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String fhirStore, @UnknownKeyFor @NonNull @Initialized String resourceType, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parameters) {
            return new FhirResourcePagesIterator(FhirMethod.SEARCH, client, fhirStore, resourceType, "", parameters);
        }

        public static @UnknownKeyFor @NonNull @Initialized FhirResourcePagesIterator ofPatientEverything(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String resourceName, @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> parameters) {
            return new FhirResourcePagesIterator(FhirMethod.PATIENT_EVERYTHING, client, "", "", resourceName, parameters);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean hasNext() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (!this.isFirstRequest) {
                return this.pageToken != null && !this.pageToken.isEmpty();
            }
            try {
                HttpBody response = this.executeFhirRequest();
                JsonObject jsonResponse = JsonParser.parseString((String)this.mapper.writeValueAsString((Object)response)).getAsJsonObject();
                JsonArray resources = jsonResponse.getAsJsonArray("entry");
                return resources != null && resources.size() != 0;
            }
            catch (IOException e) {
                throw new NoSuchElementException(String.format("Failed to list first page of FHIR resources from %s: %s", this.fhirStore, e.getMessage()));
            }
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized JsonArray next() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            try {
                HttpBody response = this.executeFhirRequest();
                this.isFirstRequest = false;
                JsonObject jsonResponse = JsonParser.parseString((String)this.mapper.writeValueAsString((Object)response)).getAsJsonObject();
                JsonArray links = jsonResponse.getAsJsonArray("link");
                this.pageToken = FhirResourcePagesIterator.parsePageToken(links);
                JsonArray resources = jsonResponse.getAsJsonArray("entry");
                return resources;
            }
            catch (IOException e) {
                this.pageToken = null;
                throw new NoSuchElementException(String.format("Error listing FHIR resources from %s: %s", this.fhirStore, e.getMessage()));
            }
        }

        private @UnknownKeyFor @NonNull @Initialized HttpBody executeFhirRequest() throws @UnknownKeyFor @NonNull @Initialized IOException {
            switch (this.fhirMethod) {
                case PATIENT_EVERYTHING: {
                    return this.client.getPatientEverything(this.resourceName, this.parameters, this.pageToken);
                }
            }
            return this.client.searchFhirResource(this.fhirStore, this.resourceType, this.parameters, this.pageToken);
        }

        private static @UnknownKeyFor @NonNull @Initialized String parsePageToken(@UnknownKeyFor @NonNull @Initialized JsonArray links) throws @UnknownKeyFor @NonNull @Initialized MalformedURLException {
            for (JsonElement e : links) {
                JsonObject link = e.getAsJsonObject();
                if (!link.get("relation").getAsString().equalsIgnoreCase("next")) continue;
                URL url = new URL(link.get("url").getAsString());
                List parameters = Splitter.on((String)"&").splitToList((CharSequence)url.getQuery());
                for (String parameter : parameters) {
                    List parts = Splitter.on((String)"=").limit(2).splitToList((CharSequence)parameter);
                    if (!((String)parts.get(0)).equalsIgnoreCase("_page_token")) continue;
                    return (String)parts.get(1);
                }
            }
            return "";
        }

        public static enum FhirMethod {
            SEARCH,
            PATIENT_EVERYTHING;

        }
    }

    public static class HL7v2MessagePages
    implements Iterable<List<HL7v2Message>> {
        private final @UnknownKeyFor @NonNull @Initialized String hl7v2Store;
        private final @UnknownKeyFor @NonNull @Initialized String filter;
        private final @UnknownKeyFor @NonNull @Initialized String orderBy;
        private final @UnknownKeyFor @NonNull @Initialized Instant start;
        private final @UnknownKeyFor @NonNull @Initialized Instant end;
        private transient @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;

        HL7v2MessagePages(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String hl7v2Store, @Nullable @UnknownKeyFor @Initialized Instant start, @Nullable @UnknownKeyFor @Initialized Instant end) {
            this(client, hl7v2Store, start, end, null, null);
        }

        HL7v2MessagePages(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String hl7v2Store, @Nullable @UnknownKeyFor @Initialized Instant start, @Nullable @UnknownKeyFor @Initialized Instant end, @Nullable @UnknownKeyFor @Initialized String filter, @Nullable @UnknownKeyFor @Initialized String orderBy) {
            this.client = client;
            this.hl7v2Store = hl7v2Store;
            this.filter = filter;
            this.orderBy = orderBy;
            this.start = start;
            this.end = end;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getStart() {
            return this.start;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getEnd() {
            return this.end;
        }

        public static @UnknownKeyFor @NonNull @Initialized ListMessagesResponse makeListRequest(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String hl7v2Store, @Nullable @UnknownKeyFor @Initialized Instant start, @Nullable @UnknownKeyFor @Initialized Instant end, @Nullable @UnknownKeyFor @Initialized String filter, @Nullable @UnknownKeyFor @Initialized String orderBy, @Nullable @UnknownKeyFor @Initialized String pageToken) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return client.makeSendTimeBoundHL7v2ListRequest(hl7v2Store, start, end, filter, orderBy, pageToken);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized HL7v2Message>> iterator() {
            return new HL7v2MessagePagesIterator(this.client, this.hl7v2Store, this.start, this.end, this.filter, this.orderBy);
        }

        public static class HL7v2MessagePagesIterator
        implements Iterator<List<HL7v2Message>> {
            private final @UnknownKeyFor @NonNull @Initialized String hl7v2Store;
            private final @UnknownKeyFor @NonNull @Initialized String filter;
            private final @UnknownKeyFor @NonNull @Initialized String orderBy;
            private final @UnknownKeyFor @NonNull @Initialized Instant start;
            private final @UnknownKeyFor @NonNull @Initialized Instant end;
            private @UnknownKeyFor @NonNull @Initialized HealthcareApiClient client;
            private @UnknownKeyFor @NonNull @Initialized String pageToken;
            private @UnknownKeyFor @NonNull @Initialized boolean isFirstRequest;

            HL7v2MessagePagesIterator(@UnknownKeyFor @NonNull @Initialized HealthcareApiClient client, @UnknownKeyFor @NonNull @Initialized String hl7v2Store, @Nullable @UnknownKeyFor @Initialized Instant start, @Nullable @UnknownKeyFor @Initialized Instant end, @Nullable @UnknownKeyFor @Initialized String filter, @Nullable @UnknownKeyFor @Initialized String orderBy) {
                this.client = client;
                this.hl7v2Store = hl7v2Store;
                this.start = start;
                this.end = end;
                this.filter = filter;
                this.orderBy = orderBy;
                this.pageToken = null;
                this.isFirstRequest = true;
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized boolean hasNext() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                if (this.isFirstRequest) {
                    try {
                        ListMessagesResponse response = HL7v2MessagePages.makeListRequest(this.client, this.hl7v2Store, this.start, this.end, this.filter, this.orderBy, this.pageToken);
                        List msgs = response.getHl7V2Messages();
                        if (msgs == null) {
                            return false;
                        }
                        return !msgs.isEmpty();
                    }
                    catch (IOException e) {
                        throw new NoSuchElementException(String.format("Failed to list first page of HL7v2 messages from %s: %s", this.hl7v2Store, e.getMessage()));
                    }
                }
                return this.pageToken != null;
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized HL7v2Message> next() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
                try {
                    ListMessagesResponse response = HL7v2MessagePages.makeListRequest(this.client, this.hl7v2Store, this.start, this.end, this.filter, this.orderBy, this.pageToken);
                    this.isFirstRequest = false;
                    this.pageToken = response.getNextPageToken();
                    List msgs = response.getHl7V2Messages();
                    return msgs.stream().map(HL7v2Message::fromModel).collect(Collectors.toList());
                }
                catch (IOException e) {
                    this.pageToken = null;
                    throw new NoSuchElementException(String.format("Error listing HL7v2 Messages from %s: %s", this.hl7v2Store, e.getMessage()));
                }
            }
        }
    }

    public static class AuthenticatedRetryInitializer
    extends RetryHttpRequestInitializer {
        @UnknownKeyFor @NonNull @Initialized GoogleCredentials credentials;

        public AuthenticatedRetryInitializer(@UnknownKeyFor @NonNull @Initialized GoogleCredentials credentials) {
            this.credentials = credentials;
        }

        public void initialize(@UnknownKeyFor @NonNull @Initialized HttpRequest request) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Map credentialHeaders;
            super.initialize(request);
            HttpHeaders requestHeaders = request.getHeaders();
            requestHeaders.setUserAgent(USER_AGENT);
            if (!this.credentials.hasRequestMetadata()) {
                return;
            }
            URI uri = null;
            if (request.getUrl() != null) {
                uri = request.getUrl().toURI();
            }
            if ((credentialHeaders = this.credentials.getRequestMetadata(uri)) == null) {
                return;
            }
            for (Map.Entry entry : credentialHeaders.entrySet()) {
                String headerName = (String)entry.getKey();
                ArrayList requestValues = new ArrayList((Collection)entry.getValue());
                requestHeaders.put(headerName, requestValues);
            }
        }
    }

    public static class HealthcareHttpException
    extends Exception {
        private final @UnknownKeyFor @NonNull @Initialized int statusCode;

        private HealthcareHttpException(@UnknownKeyFor @NonNull @Initialized int statusCode, @UnknownKeyFor @NonNull @Initialized String message) {
            super(message);
            this.statusCode = statusCode;
            if (statusCode / 100 == 2) {
                throw new IllegalArgumentException(String.format("2xx codes should not be exceptions. Got status code: %s with body: %s", statusCode, message));
            }
        }

        static @UnknownKeyFor @NonNull @Initialized HealthcareHttpException of(@UnknownKeyFor @NonNull @Initialized int statusCode, @UnknownKeyFor @NonNull @Initialized String message) {
            return new HealthcareHttpException(statusCode, message);
        }

        @UnknownKeyFor @NonNull @Initialized int getStatusCode() {
            return this.statusCode;
        }
    }
}

