/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoSocketReadException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.MongoSocketWriteTimeoutException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.AsyncCompletionHandler;
import com.mongodb.connection.SocketSettings;
import com.mongodb.internal.async.AsyncRunnable;
import com.mongodb.internal.connection.ExtendedAsynchronousByteChannel;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import com.mongodb.internal.connection.Stream;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.lang.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.nio.channels.InterruptedByTimeoutException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.ByteBuf;

public abstract class AsynchronousChannelStream
implements Stream {
    private final ServerAddress serverAddress;
    private final SocketSettings settings;
    private final PowerOfTwoBufferPool bufferProvider;
    private final AtomicReference<ExtendedAsynchronousByteChannel> channel;
    private volatile boolean isClosed;

    public AsynchronousChannelStream(ServerAddress serverAddress, SocketSettings settings, PowerOfTwoBufferPool bufferProvider) {
        this.serverAddress = serverAddress;
        this.settings = settings;
        this.bufferProvider = bufferProvider;
        this.channel = new AtomicReference();
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public SocketSettings getSettings() {
        return this.settings;
    }

    public PowerOfTwoBufferPool getBufferProvider() {
        return this.bufferProvider;
    }

    public ExtendedAsynchronousByteChannel getChannel() {
        return this.channel.get();
    }

    protected void setChannel(ExtendedAsynchronousByteChannel channel) {
        if (this.isClosed) {
            this.closeChannel(channel);
        } else {
            Assertions.assertTrue(this.channel.compareAndSet(null, channel));
            if (this.isClosed) {
                this.closeChannel(this.channel.getAndSet(null));
            }
        }
    }

    @Override
    public void writeAsync(List<ByteBuf> buffers, final OperationContext operationContext, final AsyncCompletionHandler<Void> handler) {
        final AsyncWritableByteChannelAdapter byteChannel = new AsyncWritableByteChannelAdapter();
        final Iterator<ByteBuf> iter = buffers.iterator();
        this.pipeOneBuffer(byteChannel, iter.next(), operationContext, new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(@Nullable Void t) {
                if (iter.hasNext()) {
                    AsynchronousChannelStream.this.pipeOneBuffer(byteChannel, (ByteBuf)iter.next(), operationContext, this);
                } else {
                    handler.completed(null);
                }
            }

            @Override
            public void failed(Throwable t) {
                handler.failed(t);
            }
        });
    }

    @Override
    public void readAsync(int numBytes, OperationContext operationContext, AsyncCompletionHandler<ByteBuf> handler) {
        ByteBuf buffer = this.bufferProvider.getBuffer(numBytes);
        long timeout = operationContext.getTimeoutContext().getReadTimeoutMS();
        this.getChannel().read(buffer.asNIO(), timeout, TimeUnit.MILLISECONDS, null, new BasicCompletionHandler(buffer, operationContext, handler));
    }

    @Override
    public void open(OperationContext operationContext) throws IOException {
        FutureAsyncCompletionHandler<Void> handler = new FutureAsyncCompletionHandler<Void>();
        this.openAsync(operationContext, handler);
        handler.getOpen();
    }

    @Override
    public void write(List<ByteBuf> buffers, OperationContext operationContext) throws IOException {
        FutureAsyncCompletionHandler<Void> handler = new FutureAsyncCompletionHandler<Void>();
        this.writeAsync(buffers, operationContext, handler);
        handler.getWrite();
    }

    @Override
    public ByteBuf read(int numBytes, OperationContext operationContext) throws IOException {
        FutureAsyncCompletionHandler<ByteBuf> handler = new FutureAsyncCompletionHandler<ByteBuf>();
        this.readAsync(numBytes, operationContext, handler);
        return handler.getRead();
    }

    @Override
    public ServerAddress getAddress() {
        return this.serverAddress;
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.closeChannel(this.channel.getAndSet(null));
    }

    private void closeChannel(@Nullable ExtendedAsynchronousByteChannel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public ByteBuf getBuffer(int size) {
        return this.bufferProvider.getBuffer(size);
    }

    private void pipeOneBuffer(final AsyncWritableByteChannelAdapter byteChannel, final ByteBuf byteBuffer, final OperationContext operationContext, final AsyncCompletionHandler<Void> outerHandler) {
        byteChannel.write(byteBuffer.asNIO(), operationContext, new AsyncCompletionHandler<Void>(){

            @Override
            public void completed(@Nullable Void t) {
                if (byteBuffer.hasRemaining()) {
                    byteChannel.write(byteBuffer.asNIO(), operationContext, this);
                } else {
                    outerHandler.completed(null);
                }
            }

            @Override
            public void failed(Throwable t) {
                outerHandler.failed(t);
            }
        });
    }

    private class AsyncWritableByteChannelAdapter {
        private AsyncWritableByteChannelAdapter() {
        }

        void write(ByteBuffer src, OperationContext operationContext, AsyncCompletionHandler<Void> handler) {
            AsyncRunnable.beginAsync().thenRun(c -> {
                long writeTimeoutMS = operationContext.getTimeoutContext().getWriteTimeoutMS();
                AsynchronousChannelStream.this.getChannel().write(src, writeTimeoutMS, TimeUnit.MILLISECONDS, null, new WriteCompletionHandler(c.asHandler()));
            }).finish(handler.asCallback());
        }

        private class WriteCompletionHandler
        extends BaseCompletionHandler<Void, Integer, Object> {
            WriteCompletionHandler(AsyncCompletionHandler<Void> handler) {
                super(handler);
            }

            @Override
            public void completed(Integer result, Object attachment) {
                AsyncCompletionHandler<Object> localHandler = this.getHandlerAndClear();
                localHandler.completed(null);
            }

            @Override
            public void failed(Throwable t, Object attachment) {
                AsyncCompletionHandler localHandler = this.getHandlerAndClear();
                if (t instanceof InterruptedByTimeoutException) {
                    localHandler.failed(new MongoSocketWriteTimeoutException("Timeout while writing message", AsynchronousChannelStream.this.serverAddress, t));
                } else {
                    localHandler.failed(t);
                }
            }
        }
    }

    private final class BasicCompletionHandler
    extends BaseCompletionHandler<ByteBuf, Integer, Void> {
        private final AtomicReference<ByteBuf> byteBufReference;
        private final OperationContext operationContext;

        private BasicCompletionHandler(ByteBuf dst, OperationContext operationContext, AsyncCompletionHandler<ByteBuf> handler) {
            super(handler);
            this.byteBufReference = new AtomicReference<ByteBuf>(dst);
            this.operationContext = operationContext;
        }

        @Override
        public void completed(Integer result, Void attachment) {
            AsyncCompletionHandler localHandler = this.getHandlerAndClear();
            AsyncRunnable.beginAsync().thenSupply(c -> {
                ByteBuf localByteBuf = this.byteBufReference.getAndSet(null);
                if (result == -1) {
                    localByteBuf.release();
                    throw new MongoSocketReadException("Prematurely reached end of stream", AsynchronousChannelStream.this.serverAddress);
                }
                if (!localByteBuf.hasRemaining()) {
                    localByteBuf.flip();
                    c.complete(localByteBuf);
                } else {
                    long readTimeoutMS = this.operationContext.getTimeoutContext().getReadTimeoutMS();
                    AsynchronousChannelStream.this.getChannel().read(localByteBuf.asNIO(), readTimeoutMS, TimeUnit.MILLISECONDS, null, new BasicCompletionHandler(localByteBuf, this.operationContext, c.asHandler()));
                }
            }).finish(localHandler.asCallback());
        }

        @Override
        public void failed(Throwable t, Void attachment) {
            AsyncCompletionHandler localHandler = this.getHandlerAndClear();
            ByteBuf localByteBuf = this.byteBufReference.getAndSet(null);
            localByteBuf.release();
            if (t instanceof InterruptedByTimeoutException) {
                localHandler.failed(new MongoSocketReadTimeoutException("Timeout while receiving message", AsynchronousChannelStream.this.serverAddress, t));
            } else {
                localHandler.failed(t);
            }
        }
    }

    static class FutureAsyncCompletionHandler<T>
    implements AsyncCompletionHandler<T> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private volatile T result;
        private volatile Throwable error;

        FutureAsyncCompletionHandler() {
        }

        @Override
        public void completed(@Nullable T result) {
            this.result = result;
            this.latch.countDown();
        }

        @Override
        public void failed(Throwable t) {
            this.error = t;
            this.latch.countDown();
        }

        void getOpen() throws IOException {
            this.get("Opening");
        }

        void getWrite() throws IOException {
            this.get("Writing to");
        }

        T getRead() throws IOException {
            return this.get("Reading from");
        }

        private T get(String prefix) throws IOException {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw InterruptionUtil.interruptAndCreateMongoInterruptedException(prefix + " the AsynchronousSocketChannelStream failed", e);
            }
            if (this.error != null) {
                if (this.error instanceof IOException) {
                    throw (IOException)this.error;
                }
                if (this.error instanceof MongoException) {
                    throw (MongoException)this.error;
                }
                throw new MongoInternalException(prefix + " the TlsChannelStream failed", this.error);
            }
            return this.result;
        }
    }

    private static abstract class BaseCompletionHandler<T, V, A>
    implements CompletionHandler<V, A> {
        private final AtomicReference<AsyncCompletionHandler<T>> handlerReference;

        BaseCompletionHandler(AsyncCompletionHandler<T> handler) {
            this.handlerReference = new AtomicReference<AsyncCompletionHandler<T>>(handler);
        }

        AsyncCompletionHandler<T> getHandlerAndClear() {
            return this.handlerReference.getAndSet(null);
        }
    }
}

