/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc.cdx;

import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.netpreserve.jwarc.WarcCaptureRecord;
import org.netpreserve.jwarc.cdx.CdxFormat;

public final class CdxFields {
    static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
    public static final byte ORIGINAL_URL = 97;
    public static final byte DATE = 98;
    public static final byte CHECKSUM = 107;
    public static final byte FILENAME = 103;
    public static final byte MIME_TYPE = 109;
    public static final byte REDIRECT = 114;
    public static final byte RESPONSE_CODE = 115;
    public static final byte NORMALIZED_SURT = 78;
    public static final byte COMPRESSED_RECORD_SIZE = 83;
    public static final byte COMPRESSED_ARC_FILE_OFFSET = 86;

    private CdxFields() {
    }

    public static String format(byte field, WarcCaptureRecord record) {
        try {
            return CdxFormat.CDX11.formatField(field, record, null, -1L, -1L, null);
        }
        catch (Exception e) {
            return "-";
        }
    }
}

