/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.mp4.Mp4Dictionary;
import com.drew.metadata.mp4.Mp4Directory;
import java.util.ArrayList;
import java.util.Arrays;

public class Mp4Descriptor
extends TagDescriptor<Mp4Directory> {
    public Mp4Descriptor(@NotNull Mp4Directory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getMajorBrandDescription();
            }
            case 3: {
                return this.getCompatibleBrandsDescription();
            }
            case 260: {
                return this.getDurationDescription();
            }
        }
        return ((Mp4Directory)this._directory).getString(tagType);
    }

    private String getMajorBrandDescription() {
        byte[] value = ((Mp4Directory)this._directory).getByteArray(1);
        if (value == null) {
            return null;
        }
        return Mp4Dictionary.lookup(1, new String(value));
    }

    private String getCompatibleBrandsDescription() {
        String[] values = ((Mp4Directory)this._directory).getStringArray(3);
        if (values == null) {
            return null;
        }
        ArrayList<String> compatibleBrandsValues = new ArrayList<String>();
        for (String value : values) {
            String compatibleBrandsValue = Mp4Dictionary.lookup(1, value);
            compatibleBrandsValues.add(compatibleBrandsValue == null ? value : compatibleBrandsValue);
        }
        return Arrays.toString(compatibleBrandsValues.toArray());
    }

    private String getDurationDescription() {
        Rational duration = ((Mp4Directory)this._directory).getRational(260);
        if (duration == null) {
            return null;
        }
        double value = duration.doubleValue();
        Integer hours = (int)(value / Math.pow(60.0, 2.0));
        Integer minutes = (int)(value / Math.pow(60.0, 1.0) - (double)(hours * 60));
        Integer seconds = (int)Math.ceil(value / Math.pow(60.0, 0.0) - (double)(minutes * 60));
        return String.format("%1$02d:%2$02d:%3$02d", hours, minutes, seconds);
    }
}

