/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.kinesis.CustomOptional;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisIO;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisSource;
import org.apache.beam.sdk.io.aws2.kinesis.ShardReadersPool;
import org.apache.beam.sdk.io.aws2.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.aws2.kinesis.TransientKinesisException;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KinesisReader
extends UnboundedSource.UnboundedReader<KinesisRecord> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(KinesisReader.class);
    private final  @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec;
    private final @UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesis;
    private final @UnknownKeyFor @NonNull @Initialized KinesisSource source;
    private final @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint initCheckpoint;
    private final @UnknownKeyFor @NonNull @Initialized Duration backlogBytesCheckThreshold;
    private @UnknownKeyFor @NonNull @Initialized CustomOptional<@UnknownKeyFor @NonNull @Initialized KinesisRecord> currentRecord = CustomOptional.absent();
    private @UnknownKeyFor @NonNull @Initialized long lastBacklogBytes;
    private @UnknownKeyFor @NonNull @Initialized Instant backlogBytesLastCheckTime = new Instant(0L);
    private @UnknownKeyFor @NonNull @Initialized ShardReadersPool shardReadersPool;

    KinesisReader( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec, @UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesis, @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint initCheckpoint, @UnknownKeyFor @NonNull @Initialized KinesisSource source) {
        this(spec, kinesis, initCheckpoint, source, Duration.standardSeconds((long)30L));
    }

    KinesisReader( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read spec, @UnknownKeyFor @NonNull @Initialized SimplifiedKinesisClient kinesis, @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint initCheckpoint, @UnknownKeyFor @NonNull @Initialized KinesisSource source, @UnknownKeyFor @NonNull @Initialized Duration backlogBytesCheckThreshold) {
        this.spec = (KinesisIO.Read)((Object)Preconditions.checkNotNull((Object)((Object)spec), (Object)"spec"));
        this.kinesis = (SimplifiedKinesisClient)Preconditions.checkNotNull((Object)kinesis, (Object)"kinesis");
        this.initCheckpoint = (KinesisReaderCheckpoint)Preconditions.checkNotNull((Object)initCheckpoint);
        this.source = source;
        this.backlogBytesCheckThreshold = backlogBytesCheckThreshold;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean start() throws @UnknownKeyFor @NonNull @Initialized IOException {
        LOG.info("Starting reader using {}", (Object)this.initCheckpoint);
        try {
            this.shardReadersPool = this.createShardReadersPool();
            this.shardReadersPool.start();
        }
        catch (TransientKinesisException e) {
            throw new IOException(e);
        }
        return this.advance();
    }

    public @UnknownKeyFor @NonNull @Initialized boolean advance() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.currentRecord = this.shardReadersPool.nextRecord();
        return this.currentRecord.isPresent();
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getCurrentRecordId() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        return this.currentRecord.get().getUniqueId();
    }

    public @UnknownKeyFor @NonNull @Initialized KinesisRecord getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        return this.currentRecord.get();
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
        return this.currentRecord.get().getApproximateArrivalTimestamp();
    }

    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (SimplifiedKinesisClient c = this.kinesis;){
            this.shardReadersPool.stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
        return this.shardReadersPool.getWatermark();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
        return this.shardReadersPool.getCheckpointMark();
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized UnboundedSource<@UnknownKeyFor @NonNull @Initialized KinesisRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getCurrentSource() {
        return this.source;
    }

    public @UnknownKeyFor @NonNull @Initialized long getSplitBacklogBytes() {
        if (this.shardReadersPool == null) {
            return -1L;
        }
        Instant latestRecordTimestamp = this.shardReadersPool.getLatestRecordTimestamp();
        if (latestRecordTimestamp.equals((Object)BoundedWindow.TIMESTAMP_MIN_VALUE)) {
            LOG.debug("Split backlog bytes for stream {} unknown", (Object)this.spec.getStreamName());
            return -1L;
        }
        if (latestRecordTimestamp.plus((ReadableDuration)this.spec.getUpToDateThreshold()).isAfterNow()) {
            LOG.debug("Split backlog bytes for stream {} with latest record timestamp {}: 0 (latest record timestamp is up-to-date with threshold of {})", new Object[]{this.spec.getStreamName(), latestRecordTimestamp, this.spec.getUpToDateThreshold()});
            return 0L;
        }
        if (this.backlogBytesLastCheckTime.plus((ReadableDuration)this.backlogBytesCheckThreshold).isAfterNow()) {
            LOG.debug("Split backlog bytes for {} stream with latest record timestamp {}: {} (cached value)", new Object[]{this.spec.getStreamName(), latestRecordTimestamp, this.lastBacklogBytes});
            return this.lastBacklogBytes;
        }
        try {
            this.lastBacklogBytes = this.kinesis.getBacklogBytes(this.spec.getStreamName(), latestRecordTimestamp);
            this.backlogBytesLastCheckTime = Instant.now();
        }
        catch (TransientKinesisException e) {
            LOG.warn("Transient exception occurred during backlog estimation for stream {}.", (Object)this.spec.getStreamName(), (Object)e);
        }
        LOG.info("Split backlog bytes for {} stream with {} latest record timestamp: {}", new Object[]{this.spec.getStreamName(), latestRecordTimestamp, this.lastBacklogBytes});
        return this.lastBacklogBytes;
    }

    @UnknownKeyFor @NonNull @Initialized ShardReadersPool createShardReadersPool() throws @UnknownKeyFor @NonNull @Initialized TransientKinesisException {
        return new ShardReadersPool(this.spec, this.kinesis, this.initCheckpoint);
    }
}

