/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.dynamodb.AttributeValueCoder;
import org.apache.beam.sdk.io.aws2.dynamodb.AutoValue_DynamoDBIO_Read;
import org.apache.beam.sdk.io.aws2.dynamodb.AutoValue_DynamoDBIO_Write;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

public final class DynamoDBIO {
    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> read() {
        return new AutoValue_DynamoDBIO_Read.Builder().setClientConfiguration(ClientConfiguration.builder().build()).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return new AutoValue_DynamoDBIO_Write.Builder().setClientConfiguration(ClientConfiguration.builder().build()).setDeduplicateKeys(new ArrayList<String>()).build();
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollection<Void>> {
        abstract @UnknownKeyFor @NonNull @Initialized ClientConfiguration getClientConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> getWriteItemMapperFn();

        abstract @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getDeduplicateKeys();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> withClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
            Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ClientConfiguration cannot be null");
            return this.toBuilder().setClientConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWriteRequestMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> writeItemMapperFn) {
            return this.toBuilder().setWriteItemMapperFn(writeItemMapperFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDeduplicateKeys(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> deduplicateKeys) {
            return this.toBuilder().setDeduplicateKeys(deduplicateKeys).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @Nullable @Initialized Void> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Preconditions.checkNotNull((Object)this.getClientConfiguration(), (Object)"clientConfiguration cannot be null");
            AwsOptions awsOptions = (AwsOptions)input.getPipeline().getOptions().as(AwsOptions.class);
            ClientBuilderFactory.validate(awsOptions, this.getClientConfiguration());
            return (PCollection)input.apply((PTransform)ParDo.of(new WriteFn(this)));
        }

        static class WriteFn<@UnknownKeyFor T>
        extends DoFn<T, Void> {
            private static final @UnknownKeyFor @NonNull @Initialized String RESUME_ERROR_LOG = "Error writing remaining unprocessed items to DynamoDB: {}";
            private static final @UnknownKeyFor @NonNull @Initialized String ERROR_UNPROCESSED_ITEMS = "Error writing to DynamoDB. Unprocessed items remaining";
            private transient @UnknownKeyFor @NonNull @Initialized FluentBackoff resumeBackoff;
            private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteFn.class);
            private static final @UnknownKeyFor @NonNull @Initialized Counter DYNAMO_DB_WRITE_FAILURES = Metrics.counter(WriteFn.class, (String)"DynamoDB_Write_Failures");
            private static final @UnknownKeyFor @NonNull @Initialized int BATCH_SIZE = 25;
            private transient @UnknownKeyFor @NonNull @Initialized DynamoDbClient client;
            private final @UnknownKeyFor @NonNull @Initialized Write<T> spec;
            private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue>>, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> batch;

            WriteFn(@UnknownKeyFor @NonNull @Initialized Write<T> spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
                ClientConfiguration clientConfig = this.spec.getClientConfiguration();
                AwsOptions awsOpts = (AwsOptions)options.as(AwsOptions.class);
                this.client = (DynamoDbClient)ClientBuilderFactory.buildClient(awsOpts, DynamoDbClient.builder(), clientConfig);
                this.resumeBackoff = FluentBackoff.DEFAULT.withMaxRetries(25);
                if (clientConfig != null && clientConfig.retry() != null) {
                    Duration baseBackoff = clientConfig.retry().throttledBaseBackoff();
                    Duration maxBackoff = clientConfig.retry().maxBackoff();
                    if (baseBackoff != null) {
                        this.resumeBackoff = this.resumeBackoff.withInitialBackoff(baseBackoff);
                    }
                    if (maxBackoff != null) {
                        this.resumeBackoff = this.resumeBackoff.withMaxBackoff(maxBackoff);
                    }
                }
            }

            @DoFn.StartBundle
            public void startBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized StartBundleContext context) {
                this.batch = new HashMap<KV<String, Map<String, AttributeValue>>, KV<String, WriteRequest>>();
            }

            @DoFn.ProcessElement
            public void processElement(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
                KV writeRequest = (KV)this.spec.getWriteItemMapperFn().apply(context.element());
                this.batch.put((KV<String, Map<String, AttributeValue>>)KV.of((Object)((String)writeRequest.getKey()), this.extractDeduplicateKeyValues((WriteRequest)writeRequest.getValue())), (KV<String, WriteRequest>)writeRequest);
                if (this.batch.size() >= 25) {
                    this.flushBatch();
                }
            }

            private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue> extractDeduplicateKeyValues(@UnknownKeyFor @NonNull @Initialized WriteRequest request) {
                List<String> deduplicationKeys = this.spec.getDeduplicateKeys();
                Map attributes = Collections.emptyMap();
                if (request.putRequest() != null) {
                    attributes = request.putRequest().item();
                } else if (request.deleteRequest() != null) {
                    attributes = request.deleteRequest().key();
                }
                if (attributes.isEmpty() || deduplicationKeys.isEmpty()) {
                    return attributes;
                }
                return attributes.entrySet().stream().filter(entry -> deduplicationKeys.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }

            @DoFn.FinishBundle
            public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.flushBatch();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void flushBatch() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
                if (this.batch.isEmpty()) {
                    return;
                }
                try {
                    BatchWriteItemRequest batchRequest;
                    Map writesPerTable = this.batch.values().stream().collect(Collectors.groupingBy(KV::getKey, Collectors.mapping(KV::getValue, Collectors.toList())));
                    BackOff resume = this.resumeBackoff.backoff();
                    while (!(writesPerTable = this.client.batchWriteItem(batchRequest = (BatchWriteItemRequest)BatchWriteItemRequest.builder().requestItems(writesPerTable).build()).unprocessedItems()).isEmpty() && BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)resume)) {
                    }
                    if (!writesPerTable.isEmpty()) {
                        DYNAMO_DB_WRITE_FAILURES.inc();
                        LOG.error(RESUME_ERROR_LOG, (Object)writesPerTable);
                        throw new IOException(ERROR_UNPROCESSED_ITEMS);
                    }
                }
                finally {
                    this.batch.clear();
                }
            }

            @DoFn.Teardown
            public void tearDown() {
                if (this.client != null) {
                    this.client.close();
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWriteItemMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized WriteRequest>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDeduplicateKeys(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @UnknownKeyFor @NonNull @Initialized ClientConfiguration getClientConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized ScanRequest> getScanRequestFn();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getSegmentId();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ScanResponse, T> getScanResponseMapperFn();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> withClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
            Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ClientConfiguration cannot be null");
            return this.toBuilder().setClientConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withScanRequestFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized ScanRequest> fn) {
            return this.toBuilder().setScanRequestFn(fn).build();
        }

        private @UnknownKeyFor @NonNull @Initialized Read<T> withSegmentId(@UnknownKeyFor @NonNull @Initialized Integer segmentId) {
            Preconditions.checkArgument((segmentId != null ? 1 : 0) != 0, (Object)"segmentId can not be null");
            return this.toBuilder().setSegmentId(segmentId).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withScanResponseMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ScanResponse, T> scanResultMapperFn) {
            Preconditions.checkArgument((scanResultMapperFn != null ? 1 : 0) != 0, (Object)"scanResultMapper can not be null");
            return this.toBuilder().setScanResponseMapperFn(scanResultMapperFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue>>> items() {
            Read self = this;
            return self.withScanResponseMapperFn(new ItemsMapper()).withCoder((Coder<List<Map<String, AttributeValue>>>)ListCoder.of((Coder)MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)AttributeValueCoder.of())));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            Preconditions.checkArgument((coder != null ? 1 : 0) != 0, (Object)"coder can not be null");
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.getScanResponseMapperFn() != null ? 1 : 0) != 0, (Object)"withScanResponseMapperFn() is required");
            Preconditions.checkArgument((this.getScanRequestFn() != null ? 1 : 0) != 0, (Object)"withScanRequestFn() is required");
            ScanRequest scanRequest = (ScanRequest)this.getScanRequestFn().apply(null);
            Preconditions.checkArgument((scanRequest.totalSegments() != null && scanRequest.totalSegments() > 0 ? 1 : 0) != 0, (Object)"TotalSegments is required with withScanRequestFn() and greater zero");
            AwsOptions awsOptions = (AwsOptions)input.getPipeline().getOptions().as(AwsOptions.class);
            ClientBuilderFactory.validate(awsOptions, this.getClientConfiguration());
            PCollection splits = (PCollection)((PCollection)input.apply("Create", (PTransform)Create.of((Object)((Object)this), (Object[])new Read[0]))).apply("Split", (PTransform)ParDo.of(new SplitFn()));
            splits.setCoder((Coder)SerializableCoder.of((TypeDescriptor)new TypeDescriptor<Read<T>>(){}));
            PCollection output = (PCollection)((PCollection)splits.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read", (PTransform)ParDo.of(new ReadFn()));
            output.setCoder(this.getCoder());
            return output;
        }

        static final class ItemsMapper
        implements SerializableFunction<ScanResponse, List<Map<String, AttributeValue>>> {
            ItemsMapper() {
            }

            public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue>> apply(@Nullable @UnknownKeyFor @Initialized ScanResponse scanResponse) {
                if (scanResponse == null) {
                    return Collections.emptyList();
                }
                return scanResponse.items();
            }
        }

        private static class ReadFn<@UnknownKeyFor T>
        extends DoFn<Read<T>, T> {
            private ReadFn() {
            }

            private @UnknownKeyFor @NonNull @Initialized DynamoDbClient buildClient(@UnknownKeyFor @NonNull @Initialized Read<T> spec, @UnknownKeyFor @NonNull @Initialized AwsOptions opts) {
                return (DynamoDbClient)ClientBuilderFactory.buildClient(opts, DynamoDbClient.builder(), spec.getClientConfiguration());
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Read<T> spec, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<T> out, @UnknownKeyFor @NonNull @Initialized PipelineOptions opts) {
                try (DynamoDbClient client = this.buildClient(spec, (AwsOptions)opts.as(AwsOptions.class));){
                    ScanResponse scanResponse;
                    Map lastEvaluatedKey = null;
                    do {
                        ScanRequest scanRequest = (ScanRequest)spec.getScanRequestFn().apply(null);
                        ScanRequest scanRequestWithSegment = (ScanRequest)scanRequest.toBuilder().segment(spec.getSegmentId()).exclusiveStartKey(lastEvaluatedKey).build();
                        scanResponse = client.scan(scanRequestWithSegment);
                        out.output(spec.getScanResponseMapperFn().apply((Object)scanResponse));
                    } while ((lastEvaluatedKey = scanResponse.lastEvaluatedKey()) != null && !lastEvaluatedKey.isEmpty());
                }
            }
        }

        private static class SplitFn<@UnknownKeyFor T>
        extends DoFn<Read<T>, Read<T>> {
            private SplitFn() {
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Read<T> spec, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Read<T>> out) {
                ScanRequest scanRequest = (ScanRequest)spec.getScanRequestFn().apply(null);
                for (int i = 0; i < scanRequest.totalSegments(); ++i) {
                    out.output((Object)((Read)spec).withSegmentId(i));
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setScanRequestFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized ScanRequest> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSegmentId(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setScanResponseMapperFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ScanResponse, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }
}

