/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.dispatcher.JsonResponseHistoryServerArchivist;
import org.apache.flink.runtime.dispatcher.VoidHistoryServerArchivist;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;

public interface HistoryServerArchivist {
    public CompletableFuture<Acknowledge> archiveExecutionGraph(ExecutionGraphInfo var1);

    public static HistoryServerArchivist createHistoryServerArchivist(Configuration configuration, JsonArchivist jsonArchivist, Executor ioExecutor) {
        String configuredArchivePath = (String)configuration.get(JobManagerOptions.ARCHIVE_DIR);
        if (configuredArchivePath != null) {
            Path archivePath = new Path(configuredArchivePath);
            return new JsonResponseHistoryServerArchivist(jsonArchivist, archivePath, ioExecutor);
        }
        return VoidHistoryServerArchivist.INSTANCE;
    }
}

